/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;
import java.awt.geom.Rectangle2D;

class OriginalSquarifiedAlgorithm
extends AbstractAlgorithm {
    protected static final int VERTICAL = 0;
    protected static final int HORIZONTAL = 1;
    protected static final int ASCENDING = 0;
    protected static final int DESCENDING = 1;

    OriginalSquarifiedAlgorithm() {
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D bounds = shape.getBounds2D();
        this.layout(children, 0, children.length - 1, bounds);
        return false;
    }

    void layout(MutableTreeMapNode[] items, int start, int end, Rectangle2D bounds) {
        double a;
        if (start >= (end = Math.max(end, items.length))) {
            return;
        }
        if (end - start < 2) {
            this.sliceLayout(items, start, end, bounds, bounds.getWidth() >= bounds.getHeight() ? 1 : 0, 0);
            return;
        }
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double total = OriginalSquarifiedAlgorithm.sum((TreeMapNode[])items, (int)start, (int)end);
        int mid = start;
        double b = a = items[start].getSize() / total;
        if (w < h) {
            while (mid < end) {
                double aspect = this.normAspect(h, w, a, b);
                double q = items[mid].getSize() / total;
                if (this.normAspect(h, w, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            this.sliceLayout(items, start, mid + 1, (Rectangle2D)new Rectangle2D.Double(x, y, w, h * b), bounds.getWidth() >= bounds.getHeight() ? 1 : 0, 0);
            this.layout(items, mid + 1, end, (Rectangle2D)new Rectangle2D.Double(x, y + h * b, w, h * (1.0 - b)));
        } else {
            while (mid < end) {
                double aspect = this.normAspect(w, h, a, b);
                double q = items[mid].getSize() / total;
                if (this.normAspect(w, h, a, b + q) > aspect) break;
                ++mid;
                b += q;
            }
            this.sliceLayout(items, start, mid + 1, (Rectangle2D)new Rectangle2D.Double(x, y, w * b, h), bounds.getWidth() >= bounds.getHeight() ? 1 : 0, 0);
            this.layout(items, mid + 1, end, (Rectangle2D)new Rectangle2D.Double(x + w * b, y, w * (1.0 - b), h));
        }
    }

    private double aspect(double big, double small, double a, double b) {
        return big * b / (small * a / b);
    }

    private double normAspect(double big, double small, double a, double b) {
        double x = this.aspect(big, small, a, b);
        if (x < 1.0) {
            return 1.0 / x;
        }
        return x;
    }

    public TreeMapNode[] sortDescending(MutableTreeMapNode[] items) {
        TreeMapNode[] s = new TreeMapNode[items.length];
        System.arraycopy(items, 0, s, 0, items.length);
        int n = s.length;
        boolean outOfOrder = true;
        while (outOfOrder) {
            outOfOrder = false;
            for (int i = 0; i < n - 1; ++i) {
                boolean wrong;
                boolean bl = wrong = s[i].getSize() < s[i + 1].getSize();
                if (!wrong) continue;
                TreeMapNode temp = s[i];
                s[i] = s[i + 1];
                s[i + 1] = temp;
                outOfOrder = true;
            }
        }
        return s;
    }

    void sliceLayout(MutableTreeMapNode[] items, int start, int end, Rectangle2D bounds, int orientation, int order) {
        end = Math.min(items.length, end);
        double total = OriginalSquarifiedAlgorithm.sum((TreeMapNode[])items, (int)start, (int)end);
        double a = 0.0;
        boolean vertical = bounds.getWidth() < bounds.getHeight();
        for (int i = start; i < end; ++i) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            double b = items[i].getSize() / total;
            if (vertical) {
                r.x = bounds.getX();
                r.width = bounds.getWidth();
                r.y = order == 0 ? bounds.getY() + bounds.getHeight() * a : bounds.getY() + bounds.getHeight() * (1.0 - a - b);
                r.height = bounds.getHeight() * b;
            } else {
                r.y = bounds.getY();
                r.height = bounds.getHeight();
                r.x = order == 0 ? bounds.getX() + bounds.getWidth() * a : bounds.getX() + bounds.getWidth() * (1.0 - a - b);
                r.width = bounds.getWidth() * b;
            }
            items[i].setShape((Shape)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
            a += b;
        }
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    String getName() {
        return "Squarified (Original)";
    }

    public String toString() {
        return this.getName();
    }
}

