/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class RandelhoferSquarifiedAlgorithm
extends AbstractAlgorithm {
    RandelhoferSquarifiedAlgorithm() {
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D bounds = shape.getBounds2D();
        Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        ArrayList<MutableTreeMapNode> remaining = new ArrayList<MutableTreeMapNode>(Arrays.asList(children));
        Collections.sort(remaining, new Comparator<TreeMapNode>(){
            private int asc = -1;

            @Override
            public int compare(TreeMapNode c1, TreeMapNode c2) {
                double cmp = c1.getSize() - c2.getSize();
                return cmp < 0.0 ? -this.asc : (cmp > 0.0 ? this.asc : 0);
            }
        });
        this.squarify(remaining, 0, rect);
        return false;
    }

    private void squarify(ArrayList<MutableTreeMapNode> nodes, int start, Rectangle2D.Double rect) {
        while (start < nodes.size()) {
            if (rect.getWidth() >= rect.getHeight()) {
                start = this.layoutColumn(nodes, start, rect);
                continue;
            }
            start = this.layoutRow(nodes, start, rect);
        }
    }

    private int layoutColumn(ArrayList<MutableTreeMapNode> nodes, int start, Rectangle2D.Double rect) {
        double newRatio;
        int to;
        double ratio = this.worstAspectRatio(nodes, start, start, rect.getHeight());
        double totalWeight = nodes.get(start).getSize();
        for (to = start + 1; to < nodes.size() && !((newRatio = this.worstAspectRatio(nodes, start, to, rect.getHeight())) > ratio); ++to) {
            ratio = newRatio;
            totalWeight += nodes.get(to).getSize();
        }
        double ny = rect.getY();
        double nw = totalWeight / rect.getHeight();
        for (int i = start; i < to; ++i) {
            MutableTreeMapNode node = nodes.get(i);
            Rectangle2D.Double r = new Rectangle2D.Double(rect.getX(), ny, nw, node.getSize() / nw);
            node.setShape((Shape)r);
            ny += r.getHeight();
        }
        rect = new Rectangle2D.Double(rect.getX() + nw, rect.getY(), rect.getWidth() - nw, rect.getHeight());
        return to;
    }

    private int layoutRow(ArrayList<MutableTreeMapNode> nodes, int start, Rectangle2D.Double rect) {
        double newRatio;
        int to;
        double ratio = this.worstAspectRatio(nodes, start, start, rect.getWidth());
        double totalWeight = nodes.get(start).getSize();
        for (to = start + 1; to < nodes.size() && !((newRatio = this.worstAspectRatio(nodes, start, to, rect.getWidth())) > ratio); ++to) {
            ratio = newRatio;
            totalWeight += nodes.get(to).getSize();
        }
        double nx = rect.getX();
        double nh = totalWeight / rect.getWidth();
        for (int i = start; i < to; ++i) {
            MutableTreeMapNode node = nodes.get(i);
            Rectangle2D.Double r = new Rectangle2D.Double(nx, rect.getY() + rect.getHeight() - nh, node.getSize() / nh, nh);
            node.setShape((Shape)r);
            nx += r.getWidth();
        }
        rect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() - nh);
        return to;
    }

    private double worstAspectRatio(ArrayList<MutableTreeMapNode> nodes, int from, int to, double w) {
        double s = 0.0;
        double rmax = -1.7976931348623157E308;
        double rmin = Double.MAX_VALUE;
        for (int i = from; i <= to; ++i) {
            double nodeWeight = nodes.get(i).getSize();
            s += nodeWeight;
            rmax = Math.max(rmax, nodeWeight);
            rmin = Math.min(rmin, nodeWeight);
        }
        return Math.max(w * w * rmax / (s * s), s * s / (w * w * rmin));
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    String getName() {
        return "Squarified (Randelshofer)";
    }

    public String toString() {
        return this.getName();
    }
}

