/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.substance.v4;

import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceCellStyleTableHeaderUIDelegate
extends BasicCellStyleTableHeaderUIDelegate {
    public SubstanceCellStyleTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        super(jTableHeader, cellRendererPane);
    }

    protected void customizePaint(Graphics graphics, TableColumn tableColumn, Rectangle rectangle) {
        super.customizePaint(graphics, tableColumn, rectangle);
        SubstanceCellStyleTableHeaderUIDelegate.paintGrid(this._header, graphics, tableColumn, rectangle);
    }

    static void paintGrid(JTableHeader jTableHeader, Graphics graphics, TableColumn tableColumn, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = rectangle.y + rectangle.height;
        Color color = SubstanceCellStyleTableHeaderUIDelegate.getGridColor(jTableHeader);
        float f = SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)jTableHeader));
        graphics2D.setStroke(new BasicStroke(f, 1, 2));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jTableHeader, (float)0.7f, (Graphics)graphics));
        graphics2D.drawLine(rectangle.x, (int)((float)n - f / 2.0f), rectangle.x + rectangle.width - 1, (int)((float)n - f / 2.0f));
        int n2 = jTableHeader.getTable().convertColumnIndexToView(tableColumn.getModelIndex());
        if (n2 >= 0 && n2 < jTableHeader.getColumnModel().getColumnCount()) {
            if (SubstanceCellStyleTableHeaderUIDelegate.hasLeadingVerticalGridLine(jTableHeader, rectangle, n2)) {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, n);
            }
            if (SubstanceCellStyleTableHeaderUIDelegate.hasTrailingVerticalGridLine(jTableHeader, rectangle, n2)) {
                graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, n);
            }
        }
        graphics2D.dispose();
    }

    static boolean hasTrailingVerticalGridLine(JTableHeader jTableHeader, Rectangle rectangle, int n) {
        boolean bl;
        boolean bl2 = bl = n != jTableHeader.getColumnModel().getColumnCount() - 1;
        if (!bl) {
            Container container = jTableHeader.getParent();
            bl = jTableHeader.getComponentOrientation().isLeftToRight() ? container != null && container.getWidth() > rectangle.x + rectangle.width : container != null && rectangle.x > 0;
        }
        return bl;
    }

    static boolean hasLeadingVerticalGridLine(JTableHeader jTableHeader, Rectangle rectangle, int n) {
        Container container;
        if (n != 0) {
            return false;
        }
        Container container2 = jTableHeader.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            return ((JScrollPane)container).getRowHeader() != null;
        }
        return false;
    }

    static Color getGridColor(JTableHeader jTableHeader) {
        ComponentState componentState = !jTableHeader.isEnabled() || !jTableHeader.getTable().isEnabled() ? ComponentState.DISABLED_UNSELECTED : ComponentState.DEFAULT;
        SubstanceTheme substanceTheme = SubstanceThemeUtilities.getHighlightTheme((Component)jTableHeader, (ComponentState)componentState);
        return substanceTheme.getBorderTheme().getColorScheme().getDarkColor();
    }
}

