/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.filters.swing;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.math.stat.Histogram;
import com.macrofocus.transform.MutableOneDScreenTransform;
import com.macrofocus.transform.SimpleOneDScreenTransform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class HistogramView
extends JPanel {
    private final Color a = Color.lightGray;
    private final Color b = Color.black;
    private final Color c = Color.lightGray;
    private final Color d = Color.lightGray;
    private final Orientation e;
    private Histogram f;
    private Interval g;
    private final MutableOneDScreenTransform h;
    private final SimpleBoundedInterval i;

    /*
     * WARNING - void declaration
     */
    public HistogramView(Orientation orientation) {
        void var1_1;
        this.e = orientation;
        this.i = new SimpleBoundedInterval(0.0, 1.0);
        this.h = new SimpleOneDScreenTransform((BoundedInterval)this.i, 0, false, var1_1.equals((Object)Orientation.VERTICAL));
    }

    /*
     * WARNING - void declaration
     */
    public void setHistogram(Histogram histogram) {
        this.f = histogram;
        if (this.f != null) {
            void var1_1;
            this.i.setMinMax(histogram.getMinValue(), histogram.getMaxValue());
            this.i.setValue(histogram.getMinValue(), histogram.getMaxValue() - var1_1.getMinValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRangeModel(Interval rangeModel) {
        void var1_1;
        this.g = var1_1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.f != null) {
            Dimension dimension = this.getSize();
            switch (this.e) {
                case VERTICAL: {
                    this.h.setScreenSize(dimension.height);
                    int n = dimension.width;
                    g.setColor(this.a);
                    g.drawLine(-1, 0, -1, this.h.getScreenSize() - 1);
                    ++n;
                    int n2 = this.f.getMaxCount();
                    int n3 = 0;
                    for (int i = 0; i < this.f.getNumberOfBins(); ++i) {
                        if (this.f.getCountAtBin(i) <= 0) continue;
                        int n4 = this.f.getCountAtBin(i) * n / n2;
                        double d2 = this.f.getBinMinValue(i);
                        double d3 = this.f.getBinMaxValue(i);
                        int n5 = this.h.worldToScreen(d2);
                        int n6 = this.h.worldToScreen(d3);
                        boolean bl = !this.g.isInverted() ? this.g != null && (this.g.getStart() > d2 || this.g.getEnd() < d3) : this.g != null && this.g.getStart() > d2 && this.g.getEnd() < d3;
                        g.setColor(this.c);
                        g.fillRect(0, n6, n4, n5 - n6);
                        if (bl) {
                            g.setColor(this.d);
                        } else {
                            g.setColor(this.b);
                        }
                        g.drawLine(n3, n5, n4 + 0, n5);
                        g.drawLine(n4 + 0, n5, n4 + 0, n6);
                        if (i == this.f.getNumberOfBins() - 1 || this.f.getCountAtBin(i + 1) == 0) {
                            g.drawLine(n4 + 0, n6, 0, n6);
                            n3 = 0;
                            continue;
                        }
                        n3 = n4 + 0;
                    }
                    return;
                }
                case HORIZONTAL: {
                    this.h.setScreenSize(dimension.width);
                    int n = dimension.height;
                    g.setColor(this.a);
                    g.drawLine(0, n - 1, this.h.getScreenSize() - 1, n - 1);
                    --n;
                    int n7 = this.f.getMaxCount();
                    int n8 = 0;
                    for (int i = 0; i < this.f.getNumberOfBins(); ++i) {
                        if (this.f.getCountAtBin(i) <= 0) continue;
                        int n9 = this.f.getCountAtBin(i) * n / n7;
                        double d4 = this.f.getBinMinValue(i);
                        double d5 = this.f.getBinMaxValue(i);
                        int n10 = this.h.worldToScreen(d4);
                        int n11 = this.h.worldToScreen(d5);
                        int n12 = !this.g.isInverted() ? (this.g != null && (this.g.getStart() > d4 || this.g.getEnd() < d5) ? 1 : 0) : (this.g != null && this.g.getStart() > d4 && this.g.getEnd() < d5 ? 1 : 0);
                        g.setColor(this.c);
                        g.fillRect(n10, dimension.height - n9, n11 - n10, n9);
                        if (n12 != 0) {
                            g.setColor(this.d);
                        } else {
                            g.setColor(this.b);
                        }
                        n12 = dimension.height - (n9 + 0) - 1;
                        g.drawLine(n10, dimension.height - n8, n10, n12);
                        g.drawLine(n10, n12, n11, n12);
                        if (i == this.f.getNumberOfBins() - 1 || this.f.getCountAtBin(i + 1) == 0) {
                            g.drawLine(n11, n12, n11, dimension.height);
                            n8 = 0;
                            continue;
                        }
                        n8 = n9 + 0;
                    }
                    break;
                }
            }
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

