/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.color;

import com.macrofocus.color.ColormapModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class ColormapView
extends JComponent {
    private ColormapModel colormap;

    public ColormapView() {
    }

    public ColormapView(ColormapModel colormap) {
        this.colormap = colormap;
    }

    public void setColormap(ColormapModel colormap) {
        this.colormap = colormap;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.colormap != null) {
            Dimension size = this.getSize();
            double width = size.width;
            for (int i = -1; i <= this.colormap.getColorCount(); ++i) {
                Color color = this.colormap.getColor(i);
                int x1 = (int)(width * (double)(i + 1) / (double)(this.colormap.getColorCount() + 2));
                int x2 = (int)(width * (double)(i + 2) / (double)(this.colormap.getColorCount() + 2));
                g.setColor(color);
                g.fillRect(x1, 0, x2 - x1, size.height);
            }
        }
    }
}

