/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.color;

import com.macrofocus.color.AbstractColormapModel;
import com.macrofocus.color.ColorModel;
import com.macrofocus.color.RGBColorModel;
import java.awt.Color;

public class LinearColormapModel
extends AbstractColormapModel {
    private final Color start;
    private final Color end;
    private final ColorModel[] colormap;

    public LinearColormapModel(Color start, Color end, int steps) {
        this.start = start;
        this.end = end;
        this.colormap = new ColorModel[steps + 1];
        int startRed = start.getRed();
        int startGreen = start.getGreen();
        int startBlue = start.getBlue();
        int endRed = end.getRed();
        int endGreen = end.getGreen();
        int endBlue = end.getBlue();
        int diffRed = endRed - startRed;
        int diffGreen = endGreen - startGreen;
        int diffBlue = endBlue - startBlue;
        int red = startRed;
        int green = startGreen;
        int blue = startBlue;
        int remainingSteps = steps;
        for (int i = 0; i < steps; ++i) {
            this.colormap[i] = new RGBColorModel(red, green, blue);
            int stepRed = diffRed / remainingSteps;
            int stepGreen = diffGreen / remainingSteps;
            int stepBlue = diffBlue / remainingSteps;
            red += stepRed;
            green += stepGreen;
            blue += stepBlue;
            diffRed -= stepRed;
            diffGreen -= stepGreen;
            diffBlue -= stepBlue;
            --remainingSteps;
        }
        this.colormap[steps] = new RGBColorModel(endRed, endGreen, endBlue);
    }

    public LinearColormapModel(Color start, Color intermediate, Color end, int count1, int count2) {
        int blue;
        int green;
        int red;
        int i;
        this.start = start;
        this.end = end;
        this.colormap = new ColorModel[count1 + count2];
        int startRed = start.getRed();
        int startGreen = start.getGreen();
        int startBlue = start.getBlue();
        int intRed = intermediate.getRed();
        int intGreen = intermediate.getGreen();
        int intBlue = intermediate.getBlue();
        int endRed = end.getRed();
        int endGreen = end.getGreen();
        int endBlue = end.getBlue();
        for (i = 0; i < this.colormap.length; ++i) {
            this.colormap[i] = new RGBColorModel(0, 0, 255);
        }
        for (i = 0; i < count1; ++i) {
            red = startRed - (startRed - intRed) * i / (count1 - 1);
            green = startGreen - (startGreen - intGreen) * i / (count1 - 1);
            blue = startBlue - (startBlue - intBlue) * i / (count1 - 1);
            this.colormap[i] = new RGBColorModel(red, green, blue);
        }
        for (i = 0; i < count2; ++i) {
            red = intRed - (intRed - endRed) * i / (count2 - 1);
            green = intGreen - (intGreen - endGreen) * i / (count2 - 1);
            blue = intBlue - (intBlue - endBlue) * i / (count2 - 1);
            this.colormap[count1 + i] = new RGBColorModel(red, green, blue);
        }
    }

    @Override
    public int getColorCount() {
        return this.colormap.length;
    }

    @Override
    public ColorModel getColorModel(int entry) {
        return this.colormap[entry];
    }

    public String toString() {
        return this.getClass().getName() + "[start" + this.start + ",end=" + this.end;
    }
}

