/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.DataModel;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class HSSFHelper {
    public static void saveDataModel(HSSFSheet sheet, DataModel dataModel, boolean classes) {
        HSSFHelper.saveDataModel(sheet, dataModel, classes, null);
    }

    public static void saveDataModel(HSSFSheet sheet, DataModel dataModel, boolean classes, HSSFCellStyle dateCellStyle) {
        int column;
        int rowShift = 0;
        for (column = 0; column < dataModel.getColumnCount(); ++column) {
            HSSFHelper.getCell(sheet, rowShift, column, CellType.STRING).setCellValue(dataModel.getColumnName(column).toString());
        }
        ++rowShift;
        if (classes) {
            for (column = 0; column < dataModel.getColumnCount(); ++column) {
                String className = dataModel.getColumnClass(column).getName();
                if (className.startsWith("java.lang.")) {
                    className = className.substring("java.lang.".length());
                }
                HSSFHelper.getCell(sheet, rowShift, column, CellType.STRING).setCellValue(className);
            }
            ++rowShift;
        }
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            for (int column2 = 0; column2 < dataModel.getColumnCount(); ++column2) {
                if (dataModel.isAvailable(row, column2) && dataModel.getValueAt(row, column2) != null) {
                    if (dataModel.getColumnClass(column2) == Date.class) {
                        HSSFCell hssfCell = HSSFHelper.getCell(sheet, rowShift + row, column2, CellType.NUMERIC);
                        hssfCell.setCellValue((Date)dataModel.getValueAt(row, column2));
                        if (dateCellStyle == null) continue;
                        hssfCell.setCellStyle(dateCellStyle);
                        continue;
                    }
                    if (Number.class.isAssignableFrom(dataModel.getColumnClass(column2))) {
                        HSSFCell cell = HSSFHelper.getCell(sheet, rowShift + row, column2, CellType.NUMERIC);
                        cell.setCellValue(((Number)dataModel.getValueAt(row, column2)).doubleValue());
                        continue;
                    }
                    HSSFHelper.getCell(sheet, rowShift + row, column2, CellType.STRING).setCellValue(dataModel.getValueAt(row, column2).toString());
                    continue;
                }
                HSSFHelper.getCell(sheet, rowShift + row, column2, CellType.BLANK);
            }
        }
    }

    public static HSSFSheet createOrClearSheet(HSSFWorkbook workbook, String name) {
        HSSFSheet sheet = workbook.getSheet(name);
        if (sheet == null) {
            sheet = workbook.createSheet(name);
        } else {
            HSSFHelper.clearSheet(sheet);
        }
        return sheet;
    }

    public static HSSFSheet recreate(HSSFWorkbook workbook, String name) {
        HSSFSheet sheet = workbook.getSheet(name);
        if (sheet != null) {
            workbook.removeSheetAt(workbook.getSheetIndex(name));
        }
        sheet = workbook.createSheet(name);
        return sheet;
    }

    public static void clearSheet(HSSFSheet sheet) {
        for (int row = sheet.getPhysicalNumberOfRows() - 1; row >= 0; --row) {
            HSSFRow hssfRow = sheet.getRow(row);
            if (hssfRow == null) continue;
            sheet.removeRow((Row)hssfRow);
        }
    }

    public static HSSFCell getCell(HSSFSheet sheet, int row, int column) {
        HSSFCell hssfCell;
        HSSFRow hssfRow = sheet.getRow(row);
        if (hssfRow == null) {
            hssfRow = sheet.createRow(row);
        }
        if ((hssfCell = hssfRow.getCell((int)((short)column))) == null) {
            hssfCell = hssfRow.createCell((int)((short)column));
        }
        return hssfCell;
    }

    public static HSSFCell getCell(HSSFSheet sheet, int row, int column, CellType type) {
        HSSFCell hssfCell;
        HSSFRow hssfRow = sheet.getRow(row);
        if (hssfRow == null) {
            hssfRow = sheet.createRow((int)((short)row));
        }
        if ((hssfCell = hssfRow.getCell((int)((short)column))) != null && hssfCell.getCellType() != type) {
            hssfRow.removeCell((Cell)hssfCell);
            hssfCell = null;
        }
        if (hssfCell == null) {
            hssfCell = hssfRow.createCell((int)((short)column));
        }
        hssfCell.setCellType(type);
        return hssfCell;
    }
}

