/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractMutableDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.MutableDataEvent;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.reader.TabDataReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class SimpleMutableDataModel
extends AbstractMutableDataModel {
    private List<Object[]> data;
    private Object[] labels;
    private Class[] classes;

    public SimpleMutableDataModel(DataModel dataModel) {
        this.initValues(dataModel);
    }

    public SimpleMutableDataModel(Object[] labels, Class[] classes) {
        this.labels = labels;
        this.classes = classes;
        this.data = new ArrayList<Object[]>();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.data.get(row)[column];
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.data.get(row)[column] != null;
    }

    @Override
    public Object getColumnName(int column) {
        return this.labels[column];
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.labels.length;
    }

    public void setObject(Object source, int row, int column, Object object) {
        this.data.get((int)row)[column] = object;
        this.notifyMutableDataChanged(new MutableDataEvent(source, this, row, column));
    }

    public void addRow(Object source) {
        Object[] row = new Object[this.getColumnCount()];
        this.data.add(row);
        this.notifyMutableDataChanged(new MutableDataEvent(source, this, this.getRowCount() - 1, -1));
    }

    public void removeRow(Object source, int row) {
        this.data.remove(row);
        this.notifyMutableDataChanged(new MutableDataEvent(source, this, row, -1));
    }

    public void load(Object source, Reader reader) {
        this.initValues(new SimpleDataModel(new TabDataReader(reader)));
        this.notifyMutableDataChangedAll(new MutableDataEvent(source, this, -1, -1));
    }

    public void load(Object source, DataModel dataModel) {
        this.initValues(dataModel);
        this.notifyMutableDataChangedAll(new MutableDataEvent(source, this, -1, -1));
    }

    private void initValues(DataModel dataModel) {
        int dimCount = dataModel.getColumnCount();
        this.labels = new Object[dimCount];
        this.classes = new Class[dimCount];
        this.data = new ArrayList<Object[]>(dataModel.getRowCount());
        for (int j = 0; j < dataModel.getColumnCount(); ++j) {
            this.labels[j] = dataModel.getColumnName(j);
            this.classes[j] = dataModel.getColumnClass(j);
        }
        for (int i = 0; i < dataModel.getRowCount(); ++i) {
            Object[] row = new Object[dataModel.getColumnCount()];
            for (int j = 0; j < dataModel.getColumnCount(); ++j) {
                if (!dataModel.isAvailable(i, j)) continue;
                row[j] = dataModel.getValueAt(i, j);
            }
            this.data.add(row);
        }
    }
}

