/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.cleaning;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.cleaning.AbstractRowExcluder;
import com.macrofocus.data.row.RowModel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class DuplicateRowExcluder
extends AbstractRowExcluder {
    private final DataModel dataModel;
    private final Vector andColumns;
    private Set seen;

    public DuplicateRowExcluder(DataModel dataModel) {
        this.dataModel = dataModel;
        this.andColumns = new Vector();
        this.init();
    }

    @Override
    public void init() {
        this.seen = new HashSet();
    }

    @Override
    public boolean exclude(RowModel rowModel) {
        boolean exclude = false;
        if (this.andColumns.size() > 0) {
            boolean value;
            exclude = true;
            for (int i = 0; i < this.andColumns.size() && exclude; exclude &= value, ++i) {
                ComparableRowModel comparableRowModel = new ComparableRowModel(rowModel);
                value = this.seen.contains(comparableRowModel);
                if (value) continue;
                this.seen.add(comparableRowModel);
            }
        }
        return exclude;
    }

    @Override
    public boolean exclude(int row) {
        return this.exclude(this.dataModel.getRowModel(row));
    }

    public void addAnd(Object column) {
        int index = this.dataModel.getColumnIndex(column);
        if (index != -1) {
            this.andColumns.addElement(index);
        }
    }

    private class ComparableRowModel {
        private final RowModel rowModel;

        public ComparableRowModel(RowModel rowModel) {
            this.rowModel = rowModel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ComparableRowModel)) {
                return false;
            }
            ComparableRowModel comparableRowModel = (ComparableRowModel)o;
            boolean equal = true;
            Iterator iterator = DuplicateRowExcluder.this.andColumns.iterator();
            while (iterator.hasNext() && equal) {
                int column = (Integer)iterator.next();
                if (this.rowModel.isAvailable(column) != comparableRowModel.rowModel.isAvailable(column)) {
                    equal = false;
                    continue;
                }
                if (!this.rowModel.isAvailable(column) || !comparableRowModel.rowModel.isAvailable(column)) continue;
                equal = this.rowModel.getObject(column).equals(comparableRowModel.rowModel.getObject(column));
            }
            return equal;
        }

        public int hashCode() {
            return this.rowModel.getObject((Integer)DuplicateRowExcluder.this.andColumns.elementAt(0)).hashCode();
        }
    }
}

