/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.cleaning;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.cleaning.AbstractRowExcluder;
import com.macrofocus.data.row.RowModel;
import java.util.Vector;

public class SmallerRowExcluder
extends AbstractRowExcluder {
    private final DataModel dataModel;
    private final Vector andColumns;
    private final Vector andValues;
    private final Vector orColumns;
    private final Vector orValues;

    public SmallerRowExcluder(DataModel dataModel) {
        this.dataModel = dataModel;
        this.andColumns = new Vector();
        this.andValues = new Vector();
        this.orColumns = new Vector();
        this.orValues = new Vector();
    }

    @Override
    public boolean exclude(RowModel rowModel) {
        Object value;
        int i;
        boolean exclude = false;
        if (this.andColumns.size() > 0) {
            exclude = true;
            for (i = 0; i < this.andColumns.size() && exclude; ++i) {
                value = rowModel.getObject((Integer)this.andColumns.elementAt(i));
                if (value == null || this.andValues.elementAt(i) == null || !Comparable.class.isAssignableFrom(value.getClass())) continue;
                exclude &= ((Comparable)value).compareTo(this.andValues.elementAt(i)) < 0;
            }
        }
        for (i = 0; i < this.orColumns.size() && !exclude; ++i) {
            value = rowModel.getObject((Integer)this.orColumns.elementAt(i));
            if (value == null || this.orValues.elementAt(i) == null || !Comparable.class.isAssignableFrom(value.getClass())) continue;
            exclude |= ((Comparable)value).compareTo(this.orValues.elementAt(i)) < 0;
        }
        return exclude;
    }

    @Override
    public boolean exclude(int row) {
        Object value;
        int i;
        boolean exclude = false;
        if (this.andColumns.size() > 0) {
            exclude = true;
            for (i = 0; i < this.andColumns.size() && exclude; ++i) {
                value = this.dataModel.getValueAt(row, (Integer)this.andColumns.elementAt(i));
                if (value == null || this.andValues.elementAt(i) == null || !Comparable.class.isAssignableFrom(value.getClass())) continue;
                exclude &= ((Comparable)value).compareTo(this.andValues.elementAt(i)) < 0;
            }
        }
        for (i = 0; i < this.orColumns.size() && !exclude; ++i) {
            value = this.dataModel.getValueAt(row, (Integer)this.orColumns.elementAt(i));
            if (value == null || this.orValues.elementAt(i) == null || !Comparable.class.isAssignableFrom(value.getClass())) continue;
            exclude |= ((Comparable)value).compareTo(this.orValues.elementAt(i)) < 0;
        }
        return exclude;
    }

    public void addAnd(Object column, Object value) {
        int index = this.dataModel.getColumnIndex(column);
        if (index != -1) {
            this.andColumns.addElement(index);
            this.andValues.addElement(value);
        }
    }

    public void addOr(Object column, Object value) {
        int index = this.dataModel.getColumnIndex(column);
        if (index != -1) {
            this.orColumns.addElement(index);
            this.orValues.addElement(value);
        }
    }
}

