/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.data.source.GoogleSpreadsheetDataSource;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class OpenGoogleSpreadsheetDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JFormattedTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JButton listSpreadsheetButton;
    private JComboBox spreadsheetComboBox;
    MutableSingleSelection<String> schema = new SimpleSingleSelection();
    private Action action;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public OpenGoogleSpreadsheetDialog() {
        this.$$$setupUI$$$();
        this.setTitle("Open Google Spreadhseet");
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        JTextComponent tcDatabaseComboBox = (JTextComponent)this.spreadsheetComboBox.getEditor().getEditorComponent();
        tcDatabaseComboBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenGoogleSpreadsheetDialog.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenGoogleSpreadsheetDialog.this.updateState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenGoogleSpreadsheetDialog.this.updateState();
            }
        });
        this.spreadsheetComboBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenGoogleSpreadsheetDialog.this.updateState();
            }
        }, (Object)this.spreadsheetComboBox));
        this.listSpreadsheetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenGoogleSpreadsheetDialog.this.updateSpreadsheets();
            }
        }, (Object)this.listSpreadsheetButton));
        this.updateState();
        this.buttonOK.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenGoogleSpreadsheetDialog.this.onOK();
            }
        }, (Object)this.buttonOK));
        this.buttonCancel.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenGoogleSpreadsheetDialog.this.onCancel();
            }
        }, (Object)this.buttonCancel));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenGoogleSpreadsheetDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenGoogleSpreadsheetDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        this.action.actionPerformed(new ActionEvent(this, 0, null));
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void updateState() {
        this.usernameTextField.setEnabled(true);
        this.passwordTextField.setEnabled(true);
        this.listSpreadsheetButton.setEnabled(true);
        this.buttonOK.setEnabled(true);
    }

    void updateSpreadsheets() {
        this.spreadsheetComboBox.removeAllItems();
        try {
            for (String spreadsheet : GoogleSpreadsheetDataSource.listSpreadsheets(this.usernameTextField.getText(), new String(this.passwordTextField.getPassword()))) {
                this.spreadsheetComboBox.addItem(spreadsheet);
            }
        }
        catch (Exception e) {
            SwingLogging.getInstance().process((Component)this, (Throwable)e);
        }
        if (this.spreadsheetComboBox.getItemCount() > 0) {
            this.spreadsheetComboBox.setSelectedIndex(0);
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getUsername() {
        return this.usernameTextField.getText();
    }

    public char[] getPassword() {
        return this.passwordTextField.getPassword();
    }

    public String getSpreadsheet() {
        return (String)this.spreadsheetComboBox.getSelectedItem();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        panel2.add((Component)this.buttonOK, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        panel2.add((Component)this.buttonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Username:");
        panel3.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.usernameTextField = new JFormattedTextField();
        panel3.add((Component)this.usernameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Password:");
        panel3.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.passwordTextField = new JPasswordField();
        panel3.add((Component)this.passwordTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel4.add((Component)panel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        JLabel label3 = new JLabel();
        label3.setText("Spreadsheet name:");
        panel5.add((Component)label3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel5.add((Component)panel6, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel6.add((Component)panel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.spreadsheetComboBox = new JComboBox();
        panel7.add((Component)this.spreadsheetComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.listSpreadsheetButton = new JButton();
        this.listSpreadsheetButton.setText("Reload");
        panel7.add((Component)this.listSpreadsheetButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

