/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;

public final class CacheMatrixModel
extends AbstractMatrixModel {
    private final double[][] array;
    private final boolean[][] isAvailable;
    private final Object[] name;
    private final int rowCount;
    private final int columnCount;

    public CacheMatrixModel(MatrixModel matrixModel) {
        this.columnCount = matrixModel.getColumnCount();
        this.rowCount = matrixModel.getRowCount();
        this.array = new double[this.rowCount][this.columnCount];
        this.isAvailable = new boolean[this.rowCount][this.columnCount];
        this.name = new Object[this.columnCount];
        for (int column = 0; column < matrixModel.getColumnCount(); ++column) {
            this.name[column] = matrixModel.getColumnName(column);
            for (int row = 0; row < matrixModel.getRowCount(); ++row) {
                if (matrixModel.isAvailable(row, column)) {
                    this.array[row][column] = matrixModel.getDouble(row, column);
                    this.isAvailable[row][column] = true;
                    continue;
                }
                this.isAvailable[row][column] = false;
            }
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.isAvailable[row][column];
    }

    @Override
    public Object getColumnName(int column) {
        return this.name[column];
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return Double.class;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.array[row][column];
    }
}

