/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.stat.StatMatrixModel;

public final class NormalizedMatrixModel
extends AbstractMatrixModel {
    private MatrixModel _dataset;
    private StatMatrixModel _stat;
    private double _stddevTime;

    public NormalizedMatrixModel(MatrixModel dataset, StatMatrixModel stat) {
        this(dataset, stat, 1.0);
    }

    public NormalizedMatrixModel(MatrixModel dataset, StatMatrixModel stat, double stddevTime) {
        this._dataset = dataset;
        this._stat = stat;
        this._stddevTime = stddevTime;
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this._dataset.isAvailable(row, column);
    }

    @Override
    public int getRowCount() {
        return this._dataset.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._dataset.getColumnCount();
    }

    @Override
    public double getDouble(int row, int column) {
        return (this._dataset.getDouble(row, column) - this._stat.getAvg(column)) / (this._stddevTime * this._stat.getStdev(column));
    }

    @Override
    public Object getColumnName(int column) {
        return this._dataset.getColumnName(column);
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }
}

