/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.data.matrix.AbstractMutableMatrixModel;

public final class SimpleMutableMatrixModel
extends AbstractMutableMatrixModel {
    private final double[][] array;
    private final boolean[][] isAvailable;
    private final Object[] name;
    private final int rowCount;
    private final int columnCount;

    public SimpleMutableMatrixModel(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.array = new double[rowCount][columnCount];
        this.isAvailable = new boolean[rowCount][columnCount];
        this.name = new Object[columnCount];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.array[row][column];
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.isAvailable[row][column];
    }

    @Override
    public Object getColumnName(int column) {
        return this.name[column];
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return Double.class;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void setObject(int row, int column, Object value) {
        if (value instanceof Number) {
            this.array[row][column] = ((Number)value).doubleValue();
            this.isAvailable[row][column] = true;
        }
    }

    @Override
    public double getDouble(int row, int column) {
        return this.array[row][column];
    }

    public void setDouble(int row, int column, double value) {
        this.array[row][column] = value;
        this.isAvailable[row][column] = true;
    }

    public void setColumnName(int column, Object name) {
        this.name[column] = name;
    }
}

