/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.timed;

import com.macrofocus.data.column.AbstractColumnModel;
import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.timed.TimedMatrixModel;
import com.macrofocus.data.matrix.vector.timed.AbstractTimedVectorModel;
import com.macrofocus.data.matrix.vector.timed.TimedVectorModel;
import java.util.Date;

public abstract class AbstractTimedMatrixModel
extends AbstractMatrixModel
implements TimedMatrixModel {
    @Override
    public ColumnModel getTimestampColumnModel() {
        return new TimestampColumnModel();
    }

    @Override
    public ColumnModel getTimeColumnModel() {
        return new TimeColumnModel();
    }

    @Override
    public TimedVectorModel getTimedVectorModel(final int column) {
        return new AbstractTimedVectorModel(){

            @Override
            public double getDouble(int index) {
                return AbstractTimedMatrixModel.this.getDouble2(index, column);
            }

            @Override
            public Object getName() {
                return AbstractTimedMatrixModel.this.getColumnName2(column);
            }

            @Override
            public int getRowCount() {
                return AbstractTimedMatrixModel.this.getRowCount2();
            }

            @Override
            public long getTime(int row) {
                return AbstractTimedMatrixModel.this.getTime2(row);
            }

            @Override
            public Date getTimestamp(int row) {
                return AbstractTimedMatrixModel.this.getTimestamp2(row);
            }
        };
    }

    private double getDouble2(int row, int column) {
        return this.getDouble(row, column);
    }

    private int getRowCount2() {
        return this.getRowCount();
    }

    private Object getColumnName2(int column) {
        return this.getColumnName(column);
    }

    private long getTime2(int row) {
        return this.getTime(row);
    }

    private ColumnModel getTimeColumnModel2() {
        return this.getTimestampColumnModel();
    }

    private Date getTimestamp2(int row) {
        return this.getTimestamp(row);
    }

    private class TimestampColumnModel
    extends AbstractColumnModel {
        private TimestampColumnModel() {
        }

        @Override
        public Class getMembership() {
            return Date.class;
        }

        @Override
        public Object getName() {
            return AbstractTimedMatrixModel.this.getDatesName();
        }

        @Override
        public Object getObject(int index) {
            return AbstractTimedMatrixModel.this.getTimestamp(index);
        }

        @Override
        public int getRowCount() {
            return AbstractTimedMatrixModel.this.getRowCount2();
        }

        @Override
        public boolean isAvailable(int index) {
            return true;
        }
    }

    private class TimeColumnModel
    extends AbstractColumnModel {
        private TimeColumnModel() {
        }

        @Override
        public Class getMembership() {
            return Long.class;
        }

        @Override
        public Object getName() {
            return AbstractTimedMatrixModel.this.getDatesName();
        }

        @Override
        public Object getObject(int index) {
            return AbstractTimedMatrixModel.this.getTime(index);
        }

        @Override
        public int getRowCount() {
            return AbstractTimedMatrixModel.this.getRowCount2();
        }

        @Override
        public boolean isAvailable(int index) {
            return true;
        }
    }
}

