/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.timed;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.column.AbstractColumnModel;
import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.matrix.timed.AbstractTimedMatrixModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleTimedMatrixModel
extends AbstractTimedMatrixModel {
    private final List columns = new ArrayList();
    private ColumnModel timeColumnModel;

    public SimpleTimedMatrixModel() {
    }

    public SimpleTimedMatrixModel(DataModel dataModel, String timeColumn) {
        for (int c = 0; c < dataModel.getColumnCount(); ++c) {
            ColumnModel column = dataModel.getColumnModel(c);
            if (column.getName().equals(timeColumn)) {
                this.setTimeColumnModel(column);
                continue;
            }
            this.addColumnModel(column);
        }
    }

    public void setTimeColumnModel(ColumnModel timeColumnModel) {
        this.timeColumnModel = timeColumnModel;
    }

    @Override
    public ColumnModel getTimestampColumnModel() {
        return this.timeColumnModel;
    }

    @Override
    public ColumnModel getTimeColumnModel() {
        return new AbstractColumnModel(){

            @Override
            public Class getMembership() {
                return Long.class;
            }

            @Override
            public Object getName() {
                return SimpleTimedMatrixModel.this.timeColumnModel.getName();
            }

            @Override
            public Object getObject(int index) {
                return SimpleTimedMatrixModel.this.getTime(index);
            }

            @Override
            public int getRowCount() {
                return SimpleTimedMatrixModel.this.timeColumnModel.getRowCount();
            }

            @Override
            public boolean isAvailable(int index) {
                return true;
            }
        };
    }

    public void addColumnModel(ColumnModel column) {
        if (Number.class.isAssignableFrom(column.getMembership())) {
            this.columns.add(column);
        }
    }

    @Override
    public Object getColumnName(int column) {
        return ((ColumnModel)this.columns.get(column)).getName();
    }

    @Override
    public Object getDatesName() {
        return this.timeColumnModel.getName();
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return ((ColumnModel)this.columns.get(column)).isAvailable(row);
    }

    @Override
    public long getTime(int row) {
        return this.getTimestamp(row).getTime();
    }

    @Override
    public Date getTimestamp(int row) {
        return (Date)this.timeColumnModel.getObject(row);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.timeColumnModel.getRowCount();
    }

    @Override
    public double getDouble(int row, int column) {
        return ((Number)((ColumnModel)this.columns.get(column)).getObject(row)).doubleValue();
    }
}

