/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.matrix.vector.AbstractVectorModel;

public class ColumnVectorModel
extends AbstractVectorModel {
    private final boolean isNumber;
    private ColumnModel columnModel;

    public ColumnVectorModel(ColumnModel columnModel) {
        this.columnModel = columnModel;
        this.isNumber = Number.class.isAssignableFrom(columnModel.getMembership());
    }

    @Override
    public boolean isAvailable(int index) {
        return this.columnModel.isAvailable(index);
    }

    @Override
    public double getDouble(int index) {
        if (this.isNumber) {
            return ((Number)this.columnModel.getObject(index)).doubleValue();
        }
        try {
            return Double.valueOf(this.columnModel.getObject(index).toString());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public Object getName() {
        return this.columnModel.getName();
    }

    @Override
    public int getRowCount() {
        return this.columnModel.getRowCount();
    }
}

