/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;
import com.macrofocus.data.matrix.vector.VectorHelper;
import com.macrofocus.data.matrix.vector.VectorModel;

public class SortedVectorModel
extends AbstractVectorModel {
    private double[] sorted;
    private final VectorModel vectorModel;

    public SortedVectorModel(VectorModel vectorModel) {
        this.vectorModel = vectorModel;
        this.sorted = new double[VectorHelper.getAvailableCount(vectorModel)];
        int j = 0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            if (!vectorModel.isAvailable(i)) continue;
            this.sorted[j] = vectorModel.getDouble(i);
            ++j;
        }
        SortedVectorModel.sort(this.sorted);
    }

    @Override
    public double getDouble(int index) {
        return this.sorted[index];
    }

    @Override
    public Object getName() {
        return this.vectorModel.getName();
    }

    @Override
    public int getRowCount() {
        return this.sorted.length;
    }

    private static void sort(double[] a) {
        SortedVectorModel.sort2(a, 0, a.length);
    }

    private static void sort2(double[] a, int fromIndex, int toIndex) {
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                a[i] = a[--n];
                a[n] = Double.NaN;
                continue;
            }
            if (a[i] == 0.0 && Double.doubleToLongBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        SortedVectorModel.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = SortedVectorModel.binarySearch(a, 0.0, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0;
            }
        }
    }

    private static void sort1(double[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    SortedVectorModel.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = SortedVectorModel.med3(x, l, l + s, l + 2 * s);
                m = SortedVectorModel.med3(x, m - s, m, m + s);
                n = SortedVectorModel.med3(x, n - 2 * s, n - s, n);
            }
            m = SortedVectorModel.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    SortedVectorModel.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    SortedVectorModel.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            SortedVectorModel.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        SortedVectorModel.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        SortedVectorModel.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            SortedVectorModel.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            SortedVectorModel.sort1(x, n - s, s);
        }
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            SortedVectorModel.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static int binarySearch(double[] a, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = (low + high) / 2;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

