/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.metaphone;

import com.macrofocus.data.metaphone.MetaphoneModel;
import com.macrofocus.util.math.MathHelper;

public class LevensteinMetaphoneModel
implements MetaphoneModel {
    private final String string;
    private boolean alternate;
    private int length;
    private int last;

    public LevensteinMetaphoneModel(String word) {
        this.string = word;
    }

    @Override
    public double distance(MetaphoneModel metaphoneModel) {
        int l;
        String t;
        String s = this.getWord();
        double distance = MathHelper.levenshtein((String)s, (String)(t = metaphoneModel.getWord()));
        if (distance >= (double)(l = Math.min(s.length(), t.length()))) {
            distance = 50.0;
        }
        return distance;
    }

    public String toString() {
        return this.getClass().getName() + "[string=" + this.string + "]";
    }

    @Override
    public String getWord() {
        return this.string;
    }

    @Override
    public String getPrimary() {
        return this.string;
    }

    @Override
    public String getSecondary() {
        return this.string;
    }
}

