/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.data.reader.CharMatcher;
import com.macrofocus.data.reader.SingleCharMatcher;
import com.macrofocus.data.reader.Tokenizer;
import com.macrofocus.data.reader.UltimateTokenizer;
import java.io.IOException;
import java.io.LineNumberReader;

public class TokenizerFactory {
    public static final CharMatcher[] commaMatchers = new CharMatcher[]{new SingleCharMatcher(','), new SingleCharMatcher(';')};
    private CharMatcher[] delimiters;
    private final CharMatcher quote;
    private final String endLine;

    public TokenizerFactory(CharMatcher quote, String endLine, CharMatcher ... delimiters) {
        this.delimiters = delimiters;
        this.endLine = endLine;
        this.quote = quote;
    }

    public static TokenizerFactory getTabDelimitedInstance() {
        return new TokenizerFactory(CharMatcher.getDoubleQuoteMatcher(), null, CharMatcher.getTabMatcher());
    }

    public static TokenizerFactory getCommaDelimitedInstance() {
        return new TokenizerFactory(CharMatcher.getDoubleQuoteMatcher(), null, commaMatchers);
    }

    public Tokenizer createTokenizer(LineNumberReader reader) throws IOException {
        UltimateTokenizer tokenizer = new UltimateTokenizer(reader, this.quote, this.endLine, this.delimiters);
        this.delimiters = tokenizer.getDelimeterMatchers();
        return tokenizer;
    }

    public String getEndLine() {
        return this.endLine;
    }
}

