/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.reader;

import com.macrofocus.data.reader.FileLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class URLResourceLoader
implements FileLoader {
    private final URL root;

    public URLResourceLoader(URL root) {
        this.root = root;
    }

    @Override
    public InputStream load(String name) {
        try {
            URL url = new URL(this.root.getPath() + "/" + name);
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getParent(URL url) throws MalformedURLException {
        int idx = url.getPath().lastIndexOf(47);
        if (idx != -1 && idx != url.getPath().length() - 1) {
            String parentPath = idx == 0 ? "/" : url.getPath().substring(0, idx) + "/";
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), parentPath);
        }
        return null;
    }
}

