/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.serial;

import com.macrofocus.data.serial.ClassMigration;
import com.macrofocus.data.serial.JTSClassMigration;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import javax.swing.ImageIcon;

public class MacrofocusObjectInputStream
extends ObjectInputStream {
    private static final ClassMigration jtsClassMigration = new JTSClassMigration();

    public MacrofocusObjectInputStream(InputStream input) throws IOException {
        super(input);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass osc = super.readClassDescriptor();
        if ("javax.swing.ImageIcon".equals(osc.getName())) {
            if (osc.getSerialVersionUID() == 532615968316031794L) {
                return ObjectStreamClass.lookup(ImageIcon.class);
            }
            if (osc.getSerialVersionUID() == -962022720109015502L) {
                return ObjectStreamClass.lookup(ImageIcon.class);
            }
            return ObjectStreamClass.lookup(ImageIcon.class);
        }
        ObjectStreamClass oscNew = jtsClassMigration.resolve(osc);
        if (oscNew != null && oscNew.getSerialVersionUID() == osc.getSerialVersionUID()) {
            return oscNew;
        }
        return osc;
    }
}

