/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import classycle.Analyser;
import classycle.ClassAttributes;
import classycle.NameAndSourceAttributes;
import classycle.graph.AtomicVertex;
import classycle.graph.StrongComponent;
import classycle.renderer.AbstractStrongComponentRenderer;
import classycle.util.StringPattern;
import classycle.util.TrueStringPattern;
import com.macrofocus.data.source.FileURLDataSource;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class JarDataSource
extends FileURLDataSource {
    static final String type = "Jar";
    static String[] COLUMNS = new String[]{"class name", "type", "inner class", "size", "used by", "uses internal classes", "uses external classes", "layer index", "cycle", "source", "package"};
    static Class[] CLASSES = new Class[]{String.class, String.class, Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class, String.class, String[].class};

    public JarDataSource(File file) {
        super(file);
    }

    public JarDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        String[] classFiles = new String[]{this.file.getAbsolutePath()};
        TrueStringPattern pattern = new TrueStringPattern();
        TrueStringPattern reflectionPattern = new TrueStringPattern();
        boolean mergeInnerClasses = true;
        boolean isPackagesOnly = false;
        Analyser analyser = new Analyser(classFiles, (StringPattern)pattern, (StringPattern)reflectionPattern, mergeInnerClasses);
        try {
            analyser.readAndAnalyse(isPackagesOnly);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StrongComponent[] cycles = analyser.getCondensedClassGraph();
        AtomicVertex[] graph = analyser.getClassGraph();
        Map map = analyser.getClassLayerMap();
        List list = this.getTrueCycles(cycles);
        CodeAnalysisTableModel tableModel = new CodeAnalysisTableModel(graph, map, list);
        return tableModel;
    }

    private List getTrueCycles(StrongComponent[] cycles) {
        ArrayList<StrongComponent> list = new ArrayList<StrongComponent>();
        if (cycles != null) {
            for (int i = 0; i < cycles.length; ++i) {
                if (cycles[i].getNumberOfVertices() <= 1) continue;
                list.add(cycles[i]);
            }
        }
        return list;
    }

    private static StrongComponent getCycleFor(AtomicVertex vertex, List cycles) {
        int n = cycles.size();
        for (int i = 0; i < n; ++i) {
            StrongComponent cycle = (StrongComponent)cycles.get(i);
            int m = cycle.getNumberOfVertices();
            for (int j = 0; j < m; ++j) {
                if (cycle.getVertex(j) != vertex) continue;
                return cycle;
            }
        }
        return null;
    }

    static class CodeAnalysisTableModel
    extends DefaultTableModel {
        public CodeAnalysisTableModel(AtomicVertex[] graph, Map map, List list) {
            for (int i = 0; i < graph.length; ++i) {
                AtomicVertex vertex = graph[i];
                Integer layerIndex = (Integer)map.get(vertex);
                Object[] values = new Object[11];
                NameAndSourceAttributes attributes = (NameAndSourceAttributes)vertex.getAttributes();
                String[] path = attributes.getName().split("\\.");
                values[0] = path[path.length - 1];
                values[10] = Arrays.copyOf(path, path.length - 1);
                values[3] = attributes.getSize();
                values[9] = attributes.getSources();
                if (attributes instanceof ClassAttributes) {
                    ClassAttributes ca = (ClassAttributes)attributes;
                    values[1] = ca.getType();
                    values[2] = ca.isInnerClass();
                } else {
                    values[1] = null;
                    values[2] = null;
                }
                values[4] = vertex.getNumberOfIncomingArcs();
                int usesInternal = 0;
                int usesExternal = 0;
                int n = vertex.getNumberOfOutgoingArcs();
                for (int j = 0; j < n; ++j) {
                    if (((AtomicVertex)vertex.getHeadVertex(j)).isGraphVertex()) {
                        ++usesInternal;
                        continue;
                    }
                    ++usesExternal;
                }
                values[5] = usesInternal;
                values[6] = usesExternal;
                values[7] = layerIndex;
                StrongComponent cycle = JarDataSource.getCycleFor(vertex, list);
                values[8] = cycle == null ? null : AbstractStrongComponentRenderer.createName((StrongComponent)cycle);
                this.addRow(values);
            }
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return CLASSES[columnIndex];
        }
    }
}

