/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.DataModelDataFrame;
import com.macrofocus.data.TableModelDataFrame;
import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.reader.URLResourceLoader;
import com.macrofocus.data.serial.MacrofocusObjectInputStream;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.source.zip.ExtendedZipArchiveInputStream;
import com.macrofocus.data.source.zip.PasswordProvider;
import com.macrofocus.data.source.zip.SwingPasswordProvider;
import com.macrofocus.data.source.zip.ZipArchiveEntry;
import com.macrofocus.data.table.DataModelTableModel;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.data.table.TreeMapTableModel;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.persistence.DataSourceContent;
import com.macrofocus.molap.persistence.DataSourceContentBuilder;
import com.macrofocus.util.file.CharsetToolkit;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import javax.swing.table.TableModel;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public abstract class MacrofocusDataSource
extends FileURLDataSource {
    private TableModel tableModel;
    private Document doc;
    private DataSource originalDataSource;
    private PasswordProvider passwordProvider;
    private DataSourceContent dataSourceContent;

    public MacrofocusDataSource(File file) {
        super(file);
    }

    public MacrofocusDataSource(URL url) {
        super(url);
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        DataSourceContentBuilder dataSourceContentBuilder = new DataSourceContentBuilder();
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        bis.mark(4);
        byte[] zipmagic = new byte[]{80, 75, 3, 4};
        byte[] gzipmagic = new byte[]{31, -117, 8};
        byte[] xmlmagic = new byte[]{60, 63, 120, 109};
        byte[] magic4 = new byte[4];
        bis.read(magic4);
        byte[] magic3 = new byte[3];
        System.arraycopy(magic4, 0, magic3, 0, magic3.length);
        bis.reset();
        if (Arrays.equals(zipmagic, magic4)) {
            SwingPasswordProvider passwordProvider = new SwingPasswordProvider(this.checkContentPane(contentPane));
            ExtendedZipArchiveInputStream zin = new ExtendedZipArchiveInputStream(bis, passwordProvider);
            Builder builder = new Builder(false);
            Document document = null;
            try {
                ZipArchiveEntry entry;
                while ((entry = zin.getNextZipEntry()) != null) {
                    PerfectDataReader dataReader;
                    BufferedReader reader;
                    PerfectDataReader dataReader2;
                    BufferedInputStream inputStream;
                    Object object;
                    MacrofocusObjectInputStream oin;
                    if ("datasource.ser".equals(entry.getName())) {
                        oin = new MacrofocusObjectInputStream((InputStream)((Object)zin));
                        object = null;
                        try {
                            object = oin.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            SwingLogging.getInstance().process(contentPane, (Throwable)e);
                        }
                        if (object instanceof DataModel) {
                            this.tableModel = new DataModelTableModel((DataModel)object);
                            dataSourceContentBuilder.setDataFrame((DataFrame)new DataModelDataFrame((DataModel)object));
                            continue;
                        }
                        if (object instanceof TableModel) {
                            this.tableModel = (TableModel)object;
                            dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
                            continue;
                        }
                        if (object instanceof DataFrame) {
                            DataFrame dataFrame = (DataFrame)object;
                            this.tableModel = new DataFrameTableModel(dataFrame);
                            dataSourceContentBuilder.setDataFrame(dataFrame);
                            continue;
                        }
                        this.tableModel = null;
                        continue;
                    }
                    if (this.tableModel == null && "datasource.csv".equals(entry.getName())) {
                        inputStream = new BufferedInputStream((InputStream)((Object)zin));
                        dataReader2 = new PerfectDataReader(new CharsetToolkit(inputStream, Charset.forName("UTF-8")).getReader(), TokenizerFactory.getCommaDelimitedInstance(), true, false, "String");
                        dataReader2.setFileLoader(this.getFileLoader());
                        this.tableModel = new RowMajorTableModel(dataReader2, true);
                        dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
                        zin.closeEntry();
                        continue;
                    }
                    if (this.tableModel == null && "datasource.txt".equals(entry.getName())) {
                        inputStream = new BufferedInputStream((InputStream)((Object)zin));
                        reader = new CharsetToolkit(inputStream, Charset.forName("UTF-8")).getReader();
                        dataReader = new PerfectDataReader(reader, TokenizerFactory.getTabDelimitedInstance(), true, false, "String", 0, Integer.MAX_VALUE, 1, DefaultTypemapModel.getInstance(), new TypemapModel.Builder[0]);
                        dataReader.setFileLoader(this.getFileLoader());
                        this.tableModel = new RowMajorTableModel(dataReader, true);
                        dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
                        zin.closeEntry();
                        continue;
                    }
                    if (this.isMeta(entry)) {
                        try {
                            document = builder.build((InputStream)((Object)zin));
                        }
                        catch (ParsingException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (entry.getName().endsWith(".ser")) {
                        oin = new MacrofocusObjectInputStream((InputStream)((Object)zin));
                        object = null;
                        try {
                            object = oin.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            SwingLogging.getInstance().process(contentPane, (Throwable)e);
                        }
                        String name = entry.getName().substring(0, entry.getName().lastIndexOf(".ser"));
                        if (object instanceof DataModel) {
                            dataSourceContentBuilder.addDataFrame(name, (DataFrame)new DataModelDataFrame((DataModel)object));
                            continue;
                        }
                        if (object instanceof TableModel) {
                            dataSourceContentBuilder.addDataFrame(name, (DataFrame)new TableModelDataFrame((TableModel)object));
                            continue;
                        }
                        if (!(object instanceof DataFrame)) continue;
                        DataFrame dataFrame = (DataFrame)object;
                        dataSourceContentBuilder.addDataFrame(name, dataFrame);
                        continue;
                    }
                    if (entry.getName().endsWith(".csv")) {
                        inputStream = new BufferedInputStream((InputStream)((Object)zin));
                        dataReader2 = new PerfectDataReader(new CharsetToolkit(inputStream, Charset.forName("UTF-8")).getReader(), TokenizerFactory.getCommaDelimitedInstance(), true, false, "String");
                        dataReader2.setFileLoader(this.getFileLoader());
                        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader2, true);
                        dataSourceContentBuilder.addDataFrame(entry.getName().substring(0, entry.getName().lastIndexOf(".csv")), (DataFrame)new TableModelDataFrame(tableModel));
                        zin.closeEntry();
                        continue;
                    }
                    if (entry.getName().endsWith(".txt")) {
                        inputStream = new BufferedInputStream((InputStream)((Object)zin));
                        reader = new CharsetToolkit(inputStream, Charset.forName("UTF-8")).getReader();
                        dataReader = new PerfectDataReader(reader, TokenizerFactory.getTabDelimitedInstance(), true, false, "String", 0, Integer.MAX_VALUE, 1, DefaultTypemapModel.getInstance(), new TypemapModel.Builder[0]);
                        dataReader.setFileLoader(this.getFileLoader());
                        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader, true);
                        dataSourceContentBuilder.addDataFrame(entry.getName().substring(0, entry.getName().lastIndexOf(".txt")), (DataFrame)new TableModelDataFrame(tableModel));
                        zin.closeEntry();
                        continue;
                    }
                    zin.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.doc = document;
            try {
                if (document != null) {
                    this.originalDataSource = DataSourceFactory.getDataSource(this.file != null ? this.file.getParentFile() : null, document.getRootElement(), this.getType());
                }
            }
            catch (AccessControlException e) {
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            passwordProvider.dispose();
        } else if (Arrays.equals(gzipmagic, magic3)) {
            MacrofocusObjectInputStream oin = new MacrofocusObjectInputStream(new GZIPInputStream(bis));
            Object object = null;
            try {
                object = oin.readObject();
            }
            catch (ClassNotFoundException e) {
                SwingLogging.getInstance().process(contentPane, (Throwable)e);
            }
            if (object instanceof DataModel) {
                this.tableModel = new DataModelTableModel((DataModel)object);
                dataSourceContentBuilder.setDataFrame((DataFrame)new DataModelDataFrame((DataModel)object));
            } else if (object instanceof TableModel) {
                this.tableModel = (TableModel)object;
                dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
            } else if (object instanceof DataFrame) {
                DataFrame dataFrame = (DataFrame)object;
                this.tableModel = new DataFrameTableModel(dataFrame);
                dataSourceContentBuilder.setDataFrame(dataFrame);
            } else {
                this.tableModel = null;
            }
        } else if (Arrays.equals(xmlmagic, magic4)) {
            Builder builder = new Builder(false);
            Document document = null;
            try {
                document = builder.build((InputStream)bis);
            }
            catch (ParsingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            assert (document != null);
            Element root = document.getRootElement();
            try {
                if (this.file != null) {
                    this.originalDataSource = DataSourceFactory.getDataSource(this.file.getParentFile(), root, this.getType());
                    this.tableModel = this.originalDataSource.load(contentPane);
                    dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
                } else {
                    this.originalDataSource = DataSourceFactory.getDataSource(URLResourceLoader.getParent(this.url), root, this.getType());
                    this.tableModel = this.originalDataSource.load(contentPane);
                    dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
                }
            }
            catch (IOException e) {
                SwingLogging.getInstance().process(contentPane, (Throwable)e);
            }
            catch (SQLException e) {
                SwingLogging.getInstance().process(contentPane, (Throwable)e);
            }
            this.doc = document;
        } else {
            PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(bis).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
            dataReader.setFileLoader(this.getFileLoader());
            this.tableModel = new RowMajorTableModel(dataReader);
            bis.close();
            if (this.getType().equalsIgnoreCase("TreeMap") && TreeMapTableModel.containsEmptyColumn(this.tableModel)) {
                this.tableModel = new TreeMapTableModel(this.tableModel);
                dataSourceContentBuilder.setDataFrame((DataFrame)new TableModelDataFrame(this.tableModel));
            }
        }
        bis.close();
        if (this.tableModel == null) {
            throw new IOException("Error while reading document");
        }
        this.dataSourceContent = dataSourceContentBuilder.build();
        return this.tableModel;
    }

    protected boolean isMeta(ZipArchiveEntry entry) {
        return (this.getType().toLowerCase() + ".xml").equals(entry.getName());
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return this.doc;
    }

    @Override
    public DataSource getOriginalDataSource() {
        if (this.originalDataSource != null) {
            return this.originalDataSource;
        }
        return super.getOriginalDataSource();
    }

    @Override
    public DataSourceContent loadDataSourceContent(Component contentPane) throws IOException, SQLException {
        this.loadTableModel(contentPane);
        return this.dataSourceContent;
    }
}

