/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.SimpleVersionModel;
import com.macrofocus.application.VersionModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.SimpleMatrixModel;
import com.macrofocus.data.properties.SimplePropertiesModel;
import com.macrofocus.data.source.GisModel;
import com.macrofocus.database.DatabaseModel;
import com.macrofocus.database.SimpleDatabaseModel;
import com.macrofocus.resources.properties.PropertiesModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;

public class SimpleInfoModel
implements Externalizable {
    static final long serialVersionUID = 116221269031126973L;
    private GisModel gisModel;
    private PropertiesModel propertiesModel;
    private SimpleDatabaseModel databaseModel = new SimpleDatabaseModel();
    private Date expirationDate;
    private VersionModel requiredVersion;
    private Boolean allowExport;
    private Boolean allowModification;
    private Locale locale;
    private ImageIcon logoImageIcon = null;
    private Boolean showMacrofocusLogo;
    private transient boolean convert = true;
    private static final String oldClassName = "com.macrofocus.GenericOScope.GenericDatasetModel.";

    public SimpleInfoModel() {
        this.gisModel = new GisModel();
        this.requiredVersion = new SimpleVersionModel("3.3.2");
        this.allowExport = Boolean.TRUE;
        this.allowModification = Boolean.TRUE;
        this.showMacrofocusLogo = Boolean.TRUE;
        this.propertiesModel = new SimplePropertiesModel();
    }

    public SimpleInfoModel(SimpleDatabaseModel databaseModel) {
        this();
        this.databaseModel = databaseModel;
        this.convert = false;
    }

    public SimpleInfoModel(DataModel rawDataModel) {
        this();
        this.setRawDataModel(rawDataModel);
    }

    public DatabaseModel getDatabaseModel() {
        return this.databaseModel;
    }

    public void setRawDataModel(DataModel dataModel) {
        if (!(dataModel instanceof SimpleDataModel)) {
            dataModel = new SimpleDataModel(dataModel);
        }
        this.databaseModel.addDataModel("raw", dataModel);
    }

    public DataModel getRawDataModel() {
        return this.databaseModel.getDataModel("raw");
    }

    public MatrixModel getRawMatrixModel() {
        if (this.databaseModel.getDataModel("matrix") != null) {
            return (MatrixModel)this.databaseModel.getDataModel("matrix");
        }
        return new SimpleMatrixModel(this.getRawDataModel());
    }

    private DataModel getListDataModel() {
        return this.databaseModel.getDataModel("list");
    }

    private DataModel getParallelDataModel() {
        return this.databaseModel.getDataModel("parallel");
    }

    private DataModel getTableDataModel() {
        return this.databaseModel.getDataModel("table");
    }

    private DataModel getGisDataModel() {
        return this.databaseModel.getDataModel("gis");
    }

    private DataModel getThemeDataModel() {
        return this.databaseModel.getDataModel("themes");
    }

    public GisModel getGisModel() {
        return this.gisModel;
    }

    public PropertiesModel getPropertiesModel() {
        return this.propertiesModel;
    }

    public void setProbeColumn(Object name) {
        this.propertiesModel.setValue("selectionview.probecolumn", name);
    }

    public String getProbeColumn() {
        return (String)this.getValue("selectionview.probecolumn", null);
    }

    public void setLanguage(String language) {
        this.propertiesModel.setValue("language", (Object)language);
    }

    public String getLanguage() {
        return (String)this.getValue("language", "en");
    }

    public void setLanguageMenu(Boolean enable) {
        this.propertiesModel.setValue("languageMenu", (Object)enable);
    }

    public Boolean getLanguageMenu() {
        return (Boolean)this.getValue("languageMenu", Boolean.FALSE);
    }

    public void setSingular(String singular) {
        this.propertiesModel.setValue("selectionview.singular", (Object)singular);
    }

    public String getSingular() {
        return (String)this.getValue("selectionview.singular", "object");
    }

    public void setPlural(String singular) {
        this.propertiesModel.setValue("selectionview.plural", (Object)singular);
    }

    public String getPlural() {
        return (String)this.getValue("selectionview.plural", "objects");
    }

    private void setListDataModel(DataModel dataModel) {
        if (dataModel != null) {
            if (!(dataModel instanceof SimpleDataModel)) {
                dataModel = new SimpleDataModel(dataModel);
            }
            this.databaseModel.addDataModel("list", dataModel);
        } else {
            this.databaseModel.removeDataModel("list");
        }
    }

    private void setParallelDataModel(DataModel dataModel) {
        if (dataModel != null) {
            if (!(dataModel instanceof SimpleDataModel)) {
                dataModel = new SimpleDataModel(dataModel);
            }
            this.databaseModel.addDataModel("parallel", dataModel);
        } else {
            this.databaseModel.removeDataModel("parallel");
        }
    }

    private void setTableDataModel(DataModel dataModel) {
        if (dataModel != null) {
            if (!(dataModel instanceof SimpleDataModel)) {
                dataModel = new SimpleDataModel(dataModel);
            }
            this.databaseModel.addDataModel("table", dataModel);
        } else {
            this.databaseModel.removeDataModel("table");
        }
    }

    private void setGisDataModel(DataModel dataModel) {
        if (dataModel != null) {
            if (!(dataModel instanceof SimpleDataModel)) {
                dataModel = new SimpleDataModel(dataModel);
            }
            this.databaseModel.addDataModel("gis", dataModel);
        } else {
            this.databaseModel.removeDataModel("gis");
        }
    }

    private void setThemesDataModel(DataModel dataModel) {
        if (dataModel != null) {
            if (!(dataModel instanceof SimpleDataModel)) {
                dataModel = new SimpleDataModel(dataModel);
            }
            this.databaseModel.addDataModel("themes", dataModel);
        } else {
            this.databaseModel.removeDataModel("themes");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public VersionModel getRequiredVersion() {
        return this.requiredVersion;
    }

    public void setRequiredVersion(VersionModel requiredVersion) {
        this.requiredVersion = requiredVersion;
    }

    public Boolean getAllowExport() {
        return this.allowExport;
    }

    public void setAllowExport(Boolean allowExport) {
        this.allowExport = allowExport;
    }

    public Boolean getAllowModification() {
        return this.allowModification;
    }

    public void setAllowModification(Boolean allowModification) {
        this.allowModification = allowModification;
    }

    public ImageIcon getLogoImageIcon() {
        return this.logoImageIcon;
    }

    public void setLogoImageIcon(ImageIcon logoImageIcon) {
        this.logoImageIcon = logoImageIcon;
    }

    public Boolean getShowMacrofocusLogo() {
        return this.showMacrofocusLogo;
    }

    public void setShowMacrofocusLogo(Boolean showMacrofocusLogo) {
        this.showMacrofocusLogo = showMacrofocusLogo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.databaseModel = (SimpleDatabaseModel)in.readObject();
            this.locale = null;
            this.expirationDate = null;
            this.requiredVersion = new SimpleVersionModel("3.0.1");
            this.allowExport = Boolean.TRUE;
            this.allowModification = Boolean.TRUE;
        } else if (version == 20000) {
            this.databaseModel = (SimpleDatabaseModel)in.readObject();
            this.locale = (Locale)in.readObject();
            this.expirationDate = (Date)in.readObject();
            this.requiredVersion = new SimpleVersionModel("3.0.1");
            this.allowExport = Boolean.TRUE;
            this.allowModification = Boolean.TRUE;
        } else if (version == 20100) {
            this.databaseModel = (SimpleDatabaseModel)in.readObject();
            this.locale = (Locale)in.readObject();
            this.expirationDate = (Date)in.readObject();
            this.requiredVersion = new SimpleVersionModel((String)in.readObject());
            this.allowExport = in.readBoolean();
            this.allowModification = in.readBoolean();
        }
    }

    private Object getValue(String key, Object defaultValue) {
        if (this.propertiesModel.isAvailable(key)) {
            return this.propertiesModel.getValue(key);
        }
        String oldKey = oldClassName + key;
        if (this.propertiesModel.isAvailable(oldKey)) {
            return this.propertiesModel.getValue(oldKey);
        }
        return defaultValue;
    }
}

