/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.YahooFinanceTableModel;
import com.macrofocus.persistence.ElementFactory;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.ProgressMonitor;
import javax.swing.table.TableModel;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;

public class YahooFinanceDataSource
extends AbstractDataSource {
    static final String type = "YahooFinance";
    private final String[] symbols;

    public YahooFinanceDataSource(String[] symbols) {
        this.symbols = symbols;
    }

    public YahooFinanceDataSource(Element root) {
        ArrayList<String> list = new ArrayList<String>();
        Elements children = root.getChildElements();
        for (int h = 0; h < children.size(); ++h) {
            Element child = children.get(h);
            if (!child.getLocalName().equals("Symbol")) continue;
            String name = child.getAttributeValue("name");
            list.add(name);
        }
        this.symbols = new String[list.size()];
        for (int i = 0; i < this.symbols.length; ++i) {
            this.symbols[i] = (String)list.get(i);
        }
    }

    @Override
    public com.macrofocus.persistence.Element save(File file, ElementFactory factory) {
        com.macrofocus.persistence.Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        for (String symbol : this.symbols) {
            com.macrofocus.persistence.Element element = factory.newElement("Symbol");
            element.addAttribute(factory.newAttribute("name", symbol));
            dataSource.appendChild(element);
        }
        return dataSource;
    }

    String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        ProgressMonitor progressMonitor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                progressMonitor = new ProgressMonitor(contentPane, "Retrieving indicators", "", 0, Integer.MAX_VALUE);
                progressMonitor.setMillisToDecideToPopup(50);
                progressMonitor.setMillisToPopup(50);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        return new YahooFinanceTableModel(this.symbols, progressMonitor);
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }
}

