/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source.parquet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetStream
implements InputFile {
    private final String streamId;
    private final byte[] data;

    public ParquetStream(String streamId, ByteArrayOutputStream stream) {
        this.streamId = streamId;
        this.data = stream.toByteArray();
    }

    public long getLength() throws IOException {
        return this.data.length;
    }

    public SeekableInputStream newStream() throws IOException {
        return new DelegatingSeekableInputStream(new SeekableByteArrayInputStream(this.data)){

            public void seek(long newPos) throws IOException {
                ((SeekableByteArrayInputStream)this.getStream()).setPos(Long.valueOf(newPos).intValue());
            }

            public long getPos() throws IOException {
                return Integer.valueOf(((SeekableByteArrayInputStream)this.getStream()).getPos()).longValue();
            }
        };
    }

    public String toString() {
        return "ParquetStream[" + this.streamId + "]";
    }

    public class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

