/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.spreadsheet.Cell;
import com.google.gdata.data.spreadsheet.CellEntry;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.util.ServiceException;
import com.macrofocus.data.table.AbstractTableModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpreadsheetServiceTableModel
extends AbstractTableModel {
    private SpreadsheetService service;
    private URL cellFeedUrl;
    private List<Class> classes;
    private Map<Point, CellEntry> cells = new HashMap<Point, CellEntry>();
    private Rectangle bounds;

    public SpreadsheetServiceTableModel(SpreadsheetService service, URL cellFeedUrl) {
        this.service = service;
        this.cellFeedUrl = cellFeedUrl;
        this.refresh(this.getCellFeed());
    }

    private CellFeed getCellFeed() {
        try {
            return (CellFeed)this.service.getFeed(this.cellFeedUrl, CellFeed.class);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ServiceException se) {
            se.printStackTrace();
            return null;
        }
    }

    public synchronized void refresh(CellFeed cellFeed) {
        int column;
        this.cells.clear();
        Rectangle oldBounds = this.bounds;
        Rectangle bounds = null;
        if (cellFeed != null) {
            for (CellEntry entry : cellFeed.getEntries()) {
                bounds = this.doAddCell(entry, bounds);
            }
        }
        this.bounds = bounds;
        this.classes = new ArrayList<Class>();
        for (column = 0; column < this.getColumnCount(); ++column) {
            this.classes.add(Object.class);
        }
        if (this.getRowCount() > 0) {
            Class<Object> cl;
            for (column = 0; column < this.getColumnCount(); ++column) {
                Object value;
                int row;
                cl = this.getColumnClass(column);
                for (row = 0; row < this.getRowCount(); ++row) {
                    value = this.getValueAt(row, column);
                    if (value == null) continue;
                    cl = value.getClass();
                    break;
                }
                for (row = 0; row < this.getRowCount(); ++row) {
                    value = this.getValueAt(row, column);
                    if (value == null || value.getClass() == cl) continue;
                    cl = Object.class;
                    break;
                }
                this.classes.set(column, cl);
            }
            for (column = 0; column < this.getColumnCount(); ++column) {
                cl = this.getColumnClass(column);
                if (cl != Object.class) continue;
                this.classes.set(column, String.class);
            }
        }
        this.fireTableDataChanged();
        if (oldBounds == null || oldBounds.width != bounds.width || oldBounds.height != bounds.height) {
            this.fireTableStructureChanged();
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.classes.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        CellEntry cell = this.getCell(0, columnIndex);
        if (cell == null) {
            return null;
        }
        return cell.getCell().getValue();
    }

    @Override
    public void setValueAt(Object value, int screenRow, int screenCol) {
        int row = screenRow + 2;
        int col = screenCol + 1;
        CellEntry entry = this.actuallySetCell(row, col, value.toString());
        if (entry != null) {
            this.bounds = this.doAddCell(entry, this.bounds);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.bounds.height;
    }

    @Override
    public int getColumnCount() {
        return this.bounds.width;
    }

    public CellEntry getCell(int row, int col) {
        return this.cells.get(new Point(this.bounds.x + col, this.bounds.y + row));
    }

    @Override
    public Object getValueAt(int screenRow, int screenCol) {
        CellEntry cell = this.getCell(screenRow + 1, screenCol);
        if (cell == null) {
            return null;
        }
        Cell c = cell.getCell();
        if (this.getColumnClass(screenCol) == String.class) {
            return c.getValue();
        }
        if (c.getNumericValue() != null) {
            return c.getNumericValue();
        }
        return c.getValue();
    }

    private Rectangle doAddCell(CellEntry entry, Rectangle bounds) {
        int row = entry.getCell().getRow();
        int col = entry.getCell().getCol();
        Point point = new Point(col, row);
        if (bounds != null) {
            bounds.add(point);
        } else {
            bounds = new Rectangle(point);
        }
        this.cells.put(point, entry);
        return bounds;
    }

    @Override
    public boolean isCellEditable(int screenRow, int screenCol) {
        CellEntry cell = this.getCell(screenRow + 1, screenCol + 1);
        if (cell == null) {
            return true;
        }
        return cell.getEditLink() != null;
    }

    private CellEntry actuallySetCell(int row, int col, String valueOrFormula) {
        try {
            CellEntry entry = new CellEntry(row, col, valueOrFormula);
            return (CellEntry)this.service.insert(this.cellFeedUrl, (IEntry)entry);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ServiceException se) {
            se.printStackTrace();
            return null;
        }
    }
}

