/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.util.file.filter.HtmlFileFilter;
import com.macrofocus.util.file.filter.RtfFileFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;

public class TagCloudTableModel
extends AbstractTableModel {
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Integer> frequencies = new HashMap<String, Integer>();

    public TagCloudTableModel(InputStream is, FileFilter fileFilter) {
        if (fileFilter instanceof RtfFileFilter) {
            DefaultStyledDocument doc = new DefaultStyledDocument();
            RTFEditorKit kit = new RTFEditorKit();
            try {
                kit.read(is, (Document)doc, doc.getStartPosition().getOffset());
                String str = doc.getText(doc.getStartPosition().getOffset(), doc.getLength());
                StrTokenizer tokenizer = new StrTokenizer(str, StrMatcher.splitMatcher());
                while (tokenizer.hasNext()) {
                    String token = tokenizer.nextToken();
                    this.processToken(token);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (fileFilter instanceof HtmlFileFilter) {
            HTMLDocument doc = new HTMLDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            HTMLEditorKit kit = new HTMLEditorKit();
            try {
                kit.read(is, (Document)doc, doc.getStartPosition().getOffset());
                String str = doc.getText(doc.getStartPosition().getOffset(), doc.getLength());
                StrTokenizer tokenizer = new StrTokenizer(str, StrMatcher.splitMatcher());
                while (tokenizer.hasNext()) {
                    String token = tokenizer.nextToken();
                    this.processToken(token);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String str;
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                while ((str = in.readLine()) != null) {
                    StrTokenizer tokenizer = new StrTokenizer(str, StrMatcher.splitMatcher());
                    while (tokenizer.hasNext()) {
                        String token = tokenizer.nextToken();
                        this.processToken(token);
                    }
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collections.sort(this.tags);
    }

    private void processToken(String token) {
        token = StringUtils.strip((String)token, (String)"_,;!?.:()[]{}|\"'");
        if (!StringUtils.isBlank((String)(token = StringUtils.lowerCase((String)token)))) {
            if (this.frequencies.containsKey(token)) {
                this.frequencies.put(token, this.frequencies.get(token) + 1);
            } else {
                this.tags.add(token);
                this.frequencies.put(token, 1);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Tag";
            }
            case 1: {
                return "Frequency";
            }
            case 2: {
                return "Length";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.tags.get(rowIndex);
            }
            case 1: {
                return this.frequencies.get(this.tags.get(rowIndex));
            }
            case 2: {
                return this.tags.get(rowIndex).length();
            }
        }
        return null;
    }
}

