/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.lang.text.StrTokenizer;

public class Tm3TableModel
extends AbstractTableModel {
    private double[][] numericAttributes;
    private String[][] textAttributes;
    private boolean hasHierarchy;
    private final List<String[]> paths = new ArrayList<String[]>();
    private final List<String> names = new ArrayList<String>();
    private List<String> numericAttributeNames;
    private List<String> textAttributeNames;
    private int rowCount;

    public Tm3TableModel(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String nameLine = reader.readLine().trim();
        String typeLine = reader.readLine().trim();
        reader.mark(1000000);
        StrTokenizer nameTokenizer = StrTokenizer.getTSVInstance((String)nameLine);
        StrTokenizer typeTokenizer = StrTokenizer.getTSVInstance((String)typeLine);
        this.numericAttributeNames = new ArrayList<String>();
        this.textAttributeNames = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        while (typeTokenizer.hasNext()) {
            String type = null;
            String name = null;
            try {
                type = typeTokenizer.nextToken();
                name = nameTokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                break;
            }
            type = type.trim().toLowerCase();
            if (type.equalsIgnoreCase("string")) {
                this.textAttributeNames.add(name);
            }
            ArrayList<String> dataTypOfnumericAttributes = new ArrayList<String>();
            if (type.equalsIgnoreCase("integer")) {
                this.numericAttributeNames.add(name);
                dataTypOfnumericAttributes.add("integer");
            }
            if (type.equalsIgnoreCase("double")) {
                this.numericAttributeNames.add(name);
                dataTypOfnumericAttributes.add("double");
            }
            if (type.equalsIgnoreCase("float")) {
                this.numericAttributeNames.add(name);
                dataTypOfnumericAttributes.add("float");
            }
            if (type.equalsIgnoreCase("date")) {
                this.numericAttributeNames.add(name);
                dataTypOfnumericAttributes.add("date");
            }
            if (type.equalsIgnoreCase("sfr")) {
                this.numericAttributeNames.add(name);
                dataTypOfnumericAttributes.add("sfr");
            }
            if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("double") || type.equalsIgnoreCase("date") || !type.equalsIgnoreCase("SFr")) {
                // empty if block
            }
            types.add(type);
        }
        this.rowCount = 0;
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            ++this.rowCount;
            line = reader.readLine();
        }
        this.numericAttributes = new double[this.numericAttributeNames.size()][this.rowCount];
        this.textAttributes = new String[this.textAttributeNames.size()][this.rowCount];
        reader.reset();
        int row_index = 0;
        line = reader.readLine();
        while (line != null && line.length() > 0) {
            int numeric_index = 0;
            int text_index = 0;
            StrTokenizer tokenizer = StrTokenizer.getTSVInstance((String)line);
            for (String type : types) {
                if (!tokenizer.hasNext()) continue;
                String value = tokenizer.nextToken();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (type.equalsIgnoreCase("string")) {
                    this.textAttributes[text_index][row_index] = value;
                    ++text_index;
                }
                if (type.equalsIgnoreCase("integer")) {
                    this.numericAttributes[numeric_index][row_index] = Double.parseDouble(value);
                    ++numeric_index;
                }
                if (type.equalsIgnoreCase("float")) {
                    this.numericAttributes[numeric_index][row_index] = Double.parseDouble(value);
                    ++numeric_index;
                }
                if (type.equalsIgnoreCase("double")) {
                    this.numericAttributes[numeric_index][row_index] = Double.parseDouble(value);
                    ++numeric_index;
                }
                if (type.equalsIgnoreCase("date")) {
                    StringTokenizer dateTokenizer = new StringTokenizer(value, ",");
                    String dd = dateTokenizer.nextToken();
                    String mm = dateTokenizer.nextToken();
                    String jjjj = dateTokenizer.nextToken();
                    double a = Double.parseDouble(jjjj) * 10000.0 + Double.parseDouble(mm) * 100.0 + Double.parseDouble(dd);
                    String s = dd + "." + mm + "." + jjjj;
                    this.numericAttributes[numeric_index][row_index] = a;
                    ++numeric_index;
                }
                if (!type.equalsIgnoreCase("sfr")) continue;
                this.numericAttributes[numeric_index][row_index] = Double.parseDouble(value);
                ++numeric_index;
            }
            int i = 0;
            ArrayList<String> pathElement = new ArrayList<String>();
            while (tokenizer.hasNext()) {
                this.hasHierarchy = true;
                pathElement.add(tokenizer.nextToken());
                ++i;
            }
            pathElement.add(Integer.toString(row_index));
            String[] array = new String[pathElement.size() - 1];
            this.names.add((String)pathElement.get(0));
            for (int j = 0; j < pathElement.size() - 1; ++j) {
                String s;
                array[j] = s = (String)pathElement.get(j);
            }
            this.paths.add(array);
            ++row_index;
            line = reader.readLine();
        }
        reader.close();
    }

    public Class getColumnClass(int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return String[].class;
            }
            case -1: {
                return String.class;
            }
        }
        if (columnIndex < this.textAttributeNames.size()) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return (this.hasHierarchy ? 2 : 0) + this.textAttributeNames.size() + this.numericAttributeNames.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return "Path";
            }
            case -1: {
                return "Name";
            }
        }
        if (columnIndex < this.textAttributeNames.size()) {
            return this.textAttributeNames.get(columnIndex);
        }
        return this.numericAttributeNames.get(columnIndex - this.textAttributeNames.size());
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return this.paths.get(rowIndex);
            }
            case -1: {
                return this.names.get(rowIndex);
            }
        }
        if (columnIndex < this.textAttributeNames.size()) {
            return this.textAttributes[columnIndex][rowIndex];
        }
        return this.numericAttributes[columnIndex - this.textAttributeNames.size()][rowIndex];
    }
}

