/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class TreeMapTableModel
extends AbstractTableModel {
    private TableModel tableModel;
    private final int columnCount;
    private boolean hasHierarchy;
    private List<String[]> paths;
    private final List<String> names = new ArrayList<String>();

    public TreeMapTableModel(TableModel tableModel) {
        String columnName;
        this.tableModel = tableModel;
        this.paths = new ArrayList<String[]>();
        int columns = 0;
        for (int c = 0; c < tableModel.getColumnCount() && (columnName = tableModel.getColumnName(c)) != null && !columnName.equals(""); ++c) {
            ++columns;
        }
        this.columnCount = columns;
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            int pathLength = tableModel.getColumnCount() - columns - 1;
            for (int p = 0; p < pathLength; ++p) {
                if (tableModel.getValueAt(row, columns + 1 + p) != null) continue;
                pathLength = p;
                break;
            }
            if (pathLength <= 0) continue;
            this.hasHierarchy = true;
            String[] pathElement = new String[pathLength - 1];
            for (int p = 0; p < pathLength - 1; ++p) {
                Object o = tableModel.getValueAt(row, columns + 1 + p);
                pathElement[p] = o.toString().trim();
            }
            Object o = tableModel.getValueAt(row, columns + pathLength);
            if (o != null) {
                this.names.add(o.toString());
            } else {
                this.names.add(null);
            }
            this.paths.add(pathElement);
        }
    }

    public static boolean containsEmptyColumn(TableModel tableModel) {
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            String columnName = tableModel.getColumnName(c);
            if (columnName != null && !columnName.equals("")) continue;
            return true;
        }
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return String[].class;
            }
            case -1: {
                return String.class;
            }
        }
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return (this.hasHierarchy ? 2 : 0) + this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return "Path";
            }
            case -1: {
                return "Name";
            }
        }
        return this.tableModel.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        columnIndex = this.hasHierarchy ? columnIndex - 2 : columnIndex;
        switch (columnIndex) {
            case -2: {
                return this.paths.get(rowIndex);
            }
            case -1: {
                return this.names.get(rowIndex);
            }
        }
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }
}

