/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.table.YahooFinanceTableModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ProgressMonitor;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class YahooIndustryBrowserTableModel
extends AbstractTableModel {
    List<Company> companies = new ArrayList<Company>();
    List<YahooFinanceTableModel.Stock> dataItems = new ArrayList<YahooFinanceTableModel.Stock>();

    public YahooIndustryBrowserTableModel(ProgressMonitor progressMonitor) throws IOException, ParsingException {
        List<Industry> industries = YahooIndustryBrowserTableModel.listIndustries();
        if (progressMonitor != null) {
            progressMonitor.setMaximum(industries.size());
        }
        for (int i = 0; i < industries.size(); ++i) {
            Industry industry = industries.get(i);
            if (progressMonitor != null && progressMonitor.isCanceled()) continue;
            if (progressMonitor != null) {
                progressMonitor.setProgress(i + 1);
                progressMonitor.setNote(industry.sector + "->" + industry.name);
            }
            try {
                List<Company> companies = YahooIndustryBrowserTableModel.listCompanies(industry);
                ArrayList<Company> filteredCompanies = new ArrayList<Company>();
                for (Company company : companies) {
                    if (company.symbol.contains(".")) continue;
                    filteredCompanies.add(company);
                }
                String[] symbols = new String[filteredCompanies.size()];
                for (int j = 0; j < filteredCompanies.size(); ++j) {
                    Company company = (Company)filteredCompanies.get(j);
                    symbols[j] = company.symbol;
                }
                List<YahooFinanceTableModel.Stock> stocks = YahooFinanceTableModel.getStocks(symbols, null);
                this.companies.addAll(companies);
                this.dataItems.addAll(stocks);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (ParsingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.dataItems.size();
    }

    @Override
    public int getColumnCount() {
        return YahooFinanceTableModel.getColumnCount2() + 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return YahooFinanceTableModel.getColumnClass2(columnIndex);
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return YahooFinanceTableModel.getColumnClass2(columnIndex - 2);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return YahooFinanceTableModel.getColumnName2(columnIndex);
            }
            case 1: {
                return "Sector";
            }
            case 2: {
                return "Industry";
            }
        }
        return YahooFinanceTableModel.getColumnName2(columnIndex - 2);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        YahooFinanceTableModel.Stock stock = this.dataItems.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return YahooFinanceTableModel.getValue(columnIndex, stock);
            }
            case 1: {
                return this.companies.get((int)rowIndex).industry.sector;
            }
            case 2: {
                return this.companies.get((int)rowIndex).industry.name;
            }
        }
        return YahooFinanceTableModel.getValue(columnIndex - 2, stock);
    }

    private static List<Industry> listIndustries() throws IOException, ParsingException {
        ArrayList<Industry> list = new ArrayList<Industry>();
        String url = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20yahoo.finance.sectors&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
        InputStream rstream = new URL(url).openStream();
        Builder parser = new Builder();
        Document doc = parser.build(rstream);
        Elements results = doc.getRootElement().getChildElements("results").get(0).getChildElements("sector");
        for (int i = 0; i < results.size(); ++i) {
            Element sector = results.get(i);
            String sectorName = sector.getAttributeValue("name");
            Elements industries = sector.getChildElements("industry");
            for (int j = 0; j < industries.size(); ++j) {
                Element industry = industries.get(j);
                String industryId = industry.getAttributeValue("id");
                String industryName = industry.getAttributeValue("name");
                list.add(new Industry(sectorName, industryId, industryName));
            }
        }
        return list;
    }

    private static List<Company> listCompanies(Industry industry) throws IOException, ParsingException {
        ArrayList<Company> list = new ArrayList<Company>();
        String url = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20yahoo.finance.industry%20where%20id%3D%22" + industry.id + "%22&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
        InputStream rstream = new URL(url).openStream();
        Builder parser = new Builder();
        Document doc = parser.build(rstream);
        Elements results = doc.getRootElement().getFirstChildElement("results").getChildElements("industry");
        for (int i = 0; i < results.size(); ++i) {
            Element sector = results.get(i);
            String industryName = sector.getAttributeValue("name");
            Elements companies = sector.getChildElements("company");
            for (int j = 0; j < companies.size(); ++j) {
                Element company = companies.get(j);
                String companySymbol = company.getAttributeValue("symbol");
                String companyName = company.getAttributeValue("name");
                list.add(new Company(industry, companyName, companySymbol));
            }
        }
        return list;
    }

    private static List<Quote> listQuotes(Industry industry) throws IOException, ParsingException {
        ArrayList<Quote> list = new ArrayList<Quote>();
        String url = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20yahoo.finance.quotes%20where%20symbol%20in%20(select%20company.symbol%20from%20yahoo.finance.industry%20where%20id%3D%22" + industry.id + "%22)&diagnostics=true&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
        InputStream rstream = new URL(url).openStream();
        Builder parser = new Builder();
        Document doc = parser.build(rstream);
        Elements results = doc.getRootElement().getFirstChildElement("results").getChildElements("quote");
        for (int i = 0; i < results.size(); ++i) {
            Element quote = results.get(i);
            String companySymbol = quote.getAttributeValue("symbol");
            String companyName = quote.getFirstChildElement("Name").getValue();
            String marketCapitalization = quote.getFirstChildElement("MarketCapitalization").getValue();
            list.add(new Quote(industry, companyName, companySymbol, marketCapitalization));
        }
        return list;
    }

    private static String getStringFromInputStream(InputStream is) throws Exception {
        int n;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        while ((n = reader.read(buffer)) != -1) {
            ((Writer)writer).write(buffer, 0, n);
        }
        return ((Object)writer).toString();
    }

    private static class Quote {
        Industry industry;
        String name;
        String symbol;
        String marketCapitalization;

        private Quote(Industry industry, String name, String symbol, String marketCapitalization) {
            this.industry = industry;
            this.name = name;
            this.symbol = symbol;
            this.marketCapitalization = marketCapitalization;
        }

        public String toString() {
            return "Quote{industry=" + this.industry + ", name='" + this.name + '\'' + ", symbol='" + this.symbol + '\'' + ", marketCapitalization='" + this.marketCapitalization + '\'' + '}';
        }
    }

    private static class Company {
        Industry industry;
        String name;
        String symbol;

        private Company(Industry industry, String name, String symbol) {
            this.industry = industry;
            this.name = name;
            this.symbol = symbol;
        }
    }

    private static class Industry {
        String sector;
        String id;
        String name;

        private Industry(String sector, String id, String name) {
            this.sector = sector;
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return "Industry{sector='" + this.sector + '\'' + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
        }
    }
}

