/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.type.timeseries.NumericalTimeSeries;

public final class DataModelNumericalTimeSeries
implements NumericalTimeSeries {
    private final DataModel dataModel;
    private final int timeColumn;
    private final int valueColumn;
    private Long minTime = Long.MAX_VALUE;
    private Long maxTime = Long.MIN_VALUE;
    private Number minValue;
    private Number maxValue;
    private final int first;
    private final int count;

    public DataModelNumericalTimeSeries(DataModel dataModel, int timeColumn, int valueColumn) {
        this(dataModel, timeColumn, valueColumn, 0, dataModel.getRowCount());
    }

    public DataModelNumericalTimeSeries(DataModel dataModel, int timeColumn, int valueColumn, int first, int count) {
        int i;
        this.dataModel = dataModel;
        this.timeColumn = timeColumn;
        this.valueColumn = valueColumn;
        this.first = first;
        this.count = count;
        for (i = 0; i < this.count; ++i) {
            long time = this.getTime(i);
            if (time < this.minTime) {
                this.minTime = time;
            }
            if (time <= this.maxTime) continue;
            this.maxTime = time;
        }
        if (Number.class.isAssignableFrom(dataModel.getColumnClass(valueColumn))) {
            for (i = 0; i < this.count; ++i) {
                Number value = (Number)this.getValue(i);
                if (this.minValue == null || value.doubleValue() < this.minValue.doubleValue()) {
                    this.minValue = value;
                }
                if (this.maxValue != null && !(value.doubleValue() > this.maxValue.doubleValue())) continue;
                this.maxValue = value;
            }
        }
    }

    @Override
    public Class getType() {
        return this.dataModel.getColumnClass(this.valueColumn);
    }

    @Override
    public long getTime(int index) {
        return ((Number)this.dataModel.getValueAt(this.first + index, this.timeColumn)).longValue();
    }

    @Override
    public Object getValue(int index) {
        return this.dataModel.getValueAt(this.first + index, this.valueColumn);
    }

    @Override
    public int getItemCount() {
        return this.count;
    }

    @Override
    public long getMinTime() {
        return this.minTime;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }
}

