/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.NumericalTimeSeries;
import com.macrofocus.data.type.timeseries.TimeSeries;
import java.util.ArrayList;
import java.util.List;

public class SimpleNumericalTimeSeries<T extends Number>
implements NumericalTimeSeries<T> {
    private List<Long> times;
    private List<T> values;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private T minValue;
    private T maxValue;
    private Class<? extends T> type;

    public SimpleNumericalTimeSeries(TimeSeries<T> timeSeries) {
        this(timeSeries.getType());
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            this.addValue(timeSeries.getTime(i), (Number)timeSeries.getValue(i));
        }
    }

    public SimpleNumericalTimeSeries(Class<? extends T> type) {
        assert (Number.class.isAssignableFrom(type)) : "Invalid type " + type;
        this.type = type;
        this.times = new ArrayList<Long>();
        this.values = new ArrayList<T>();
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        return this.times.get(index);
    }

    @Override
    public T getValue(int index) {
        return (T)((Number)this.values.get(index));
    }

    @Override
    public int getItemCount() {
        return this.times.size();
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void addValue(Long time, T value) {
        assert (value == null || value instanceof Number) : value + ", " + (value != null ? value.getClass() : "null");
        this.times.add(time);
        this.values.add(value);
        if (time < this.min) {
            this.min = time;
        }
        if (time > this.max) {
            this.max = time;
        }
        if (value instanceof Number) {
            if (this.minValue == null || ((Number)value).doubleValue() < ((Number)this.minValue).doubleValue()) {
                this.minValue = value;
            }
            if (this.maxValue == null || ((Number)value).doubleValue() > ((Number)this.maxValue).doubleValue()) {
                this.maxValue = value;
            }
        }
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }
}

