/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.database;

import com.macrofocus.data.DataModel;
import com.macrofocus.database.AbstractDatabaseModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleDatabaseModel
extends AbstractDatabaseModel
implements Externalizable {
    static final long serialVersionUID = 4863824556529176169L;
    private Map<Object, DataModel> map = new HashMap<Object, DataModel>();
    private List<DataModel> dataModels = new ArrayList<DataModel>();
    private List<Object> names = new ArrayList<Object>();

    @Override
    public DataModel getDataModel(Object name) {
        return this.map.get(name);
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataModels.get(index);
    }

    @Override
    public Object getDataModelName(int index) {
        return this.names.get(index);
    }

    @Override
    public int getDataModelCount() {
        return this.dataModels.size();
    }

    public void addDataModel(Object name, DataModel dataModel) {
        this.removeDataModel(name);
        if (dataModel != null) {
            this.map.put(name, dataModel);
            this.dataModels.add(dataModel);
            this.names.add(name);
        }
    }

    public void removeDataModel(Object name) {
        if (this.map.containsKey(name)) {
            DataModel dataModel = this.map.get(name);
            this.dataModels.remove(dataModel);
            this.names.remove(name);
            this.map.remove(name);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeInt(this.dataModels.size());
        for (int i = 0; i < this.dataModels.size(); ++i) {
            out.writeObject(this.names.get(i));
            out.writeObject(this.dataModels.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            int size = in.readInt();
            this.map = new HashMap<Object, DataModel>(size);
            this.names = new ArrayList<Object>(size);
            this.dataModels = new ArrayList<DataModel>(size);
            for (int i = 0; i < size; ++i) {
                this.addDataModel(in.readObject(), (DataModel)in.readObject());
            }
        }
    }
}

