/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.persistence.json;

import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.Elements;
import com.macrofocus.persistence.json.JSONElements;
import com.macrofocus.persistence.json.JSONObjectAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArrayElement
implements Element {
    private final JSONObject jsonObject;
    private final String name;
    private final int i;

    public JSONArrayElement(JSONObject jsonObject, String name, int i) {
        this.jsonObject = jsonObject;
        this.name = name;
        this.i = i;
    }

    public String getLocalName() {
        return this.name;
    }

    public Attribute getAttribute(int index) {
        return this.getAttribute(this.getAttributes().get(index));
    }

    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    private List<String> getAttributes() {
        JSONObject jsonObject = this.jsonObject.getJSONArray(this.name).getJSONObject(this.i);
        ArrayList<String> children = new ArrayList<String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object o = jsonObject.get((String)key);
            if (o instanceof JSONObject || o instanceof JSONArray) continue;
            children.add((String)key);
        }
        return children;
    }

    public Attribute getAttribute(String key) {
        JSONObject jsonObject = this.jsonObject.getJSONArray(this.name).getJSONObject(this.i);
        if (jsonObject != null) {
            return new JSONObjectAttribute(jsonObject, key);
        }
        return null;
    }

    public Elements getChildElements() {
        JSONObject jsonObject = this.jsonObject.getJSONArray(this.name).getJSONObject(this.i);
        return new JSONElements(jsonObject);
    }

    public String getAttributeValue(String key) {
        Attribute attribute = this.getAttribute(key);
        return attribute != null ? attribute.getValue() : null;
    }

    public void addAttribute(Attribute attribute) {
    }

    public void appendChild(Element element) {
    }
}

