/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.file.filter;

import com.macrofocus.util.file.FileHelper;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.Objects;

public abstract class AbstractFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private boolean allowDirectories = true;

    public AbstractFileFilter() {
    }

    public AbstractFileFilter(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            boolean accept;
            boolean bl = accept = f.isDirectory() && this.allowDirectories;
            if (!accept) {
                String suffix = FileHelper.getSuffix(f);
                for (String ext : this.getExtensions()) {
                    if (suffix == null || ext == null) continue;
                    boolean bl2 = accept = suffix.compareToIgnoreCase(ext) == 0;
                    if (!accept) continue;
                    return true;
                }
            }
            return accept;
        }
        return false;
    }

    public boolean accept(URL f) {
        if (f != null) {
            String suffix = FileHelper.getSuffix(f.getPath());
            boolean accept = false;
            for (String ext : this.getExtensions()) {
                if (suffix == null || ext == null) continue;
                boolean bl = accept = suffix.compareToIgnoreCase(ext) == 0;
                if (!accept) continue;
                return true;
            }
            return accept;
        }
        return false;
    }

    public boolean accept(String f) {
        if (f != null) {
            String suffix = FileHelper.getSuffix(f);
            boolean accept = false;
            for (String ext : this.getExtensions()) {
                if (suffix == null || ext == null) continue;
                boolean bl = accept = suffix.compareToIgnoreCase(ext) == 0;
                if (!accept) continue;
                return true;
            }
            return accept;
        }
        return false;
    }

    public boolean acceptContentType(String contentType) {
        return false;
    }

    public abstract String getDefaultExtension();

    public String[] getExtensions() {
        return new String[]{this.getDefaultExtension()};
    }

    public abstract String getName();

    @Override
    public String getDescription() {
        return this.buildDescription(this.getName());
    }

    public String buildDescription(String name) {
        StringBuffer buffer = new StringBuffer(name);
        buffer.append(" (");
        boolean first = true;
        for (String s : this.getExtensions()) {
            if (!first) {
                buffer.append(";");
            }
            buffer.append("*.");
            buffer.append(s);
            first = false;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFileFilter)) {
            return false;
        }
        AbstractFileFilter that = (AbstractFileFilter)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

