/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole;

import com.macrofocus.util.ole.BbdBlockModel;
import com.macrofocus.util.ole.BbdModel;
import com.macrofocus.util.ole.HeaderBlockModel;
import com.macrofocus.util.ole.OleInputStream;
import com.macrofocus.util.ole.OleModel;
import com.macrofocus.util.ole.PpsBlockModel;
import com.macrofocus.util.ole.PpsModel;
import com.macrofocus.util.ole.SimpleBbdModel;
import com.macrofocus.util.ole.SimpleOleInputStream;
import com.macrofocus.util.ole.SimplePpsModel;
import com.macrofocus.util.ole.XbdbBlockModel;
import java.io.IOException;
import java.io.InputStream;

public class SimpleOleModel
implements OleModel {
    private BbdModel bbdModel;
    private PpsModel ppsModel;
    private byte[][] blocks;

    public SimpleOleModel(InputStream is) {
        int length = 0;
        try {
            length = is.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int blockCount = 0;
        if (length % 512 == 0) {
            blockCount = length / 512;
        } else {
            System.err.println("Not an OLE container");
        }
        this.blocks = new byte[blockCount][512];
        for (int b = 0; b < blockCount; ++b) {
            try {
                is.read(this.blocks[b]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HeaderBlockModel headerBlockModel = new HeaderBlockModel(this.blocks[0]);
        this.bbdModel = new SimpleBbdModel();
        int count = 0;
        for (int i = 0; i < Math.min(headerBlockModel.getBbdBlockCount(), 109); ++i) {
            BbdBlockModel bbdBlockModel = new BbdBlockModel(this.blocks[headerBlockModel.getBbdBlock(i) + 1]);
            this.bbdModel.addBbdBlockModel(bbdBlockModel);
            ++count;
        }
        int remaining = headerBlockModel.getBbdBlockCount() - count;
        int nextBlock = headerBlockModel.getXSbdBlock() + 1;
        count = 0;
        for (int i = 0; i < headerBlockModel.getXBbdBlockCount(); ++i) {
            XbdbBlockModel xbdbBlockModel = new XbdbBlockModel(this.blocks[nextBlock]);
            for (int j = 0; j < 127 && count < remaining; ++j, ++count) {
                BbdBlockModel bbdBlockModel = new BbdBlockModel(this.blocks[xbdbBlockModel.getBbdBlock(j) + 1]);
                this.bbdModel.addBbdBlockModel(bbdBlockModel);
            }
            nextBlock = xbdbBlockModel.getNextXbbdBlock() + 1;
        }
        this.ppsModel = new SimplePpsModel();
        int block = headerBlockModel.getRootBlock() + 1;
        do {
            PpsBlockModel ppsBlockModel;
            for (int i = 0; i < 4 && (ppsBlockModel = new PpsBlockModel(this.blocks[block], i)).getSizeOfName() != 0; ++i) {
                this.ppsModel.addPpsBlockModel(ppsBlockModel);
            }
        } while ((block = this.bbdModel.getNextBlockIndex(block - 1) + 1) != -1 && block != -2 && block != -3);
    }

    @Override
    public PpsModel getPpsModel() {
        return this.ppsModel;
    }

    @Override
    public OleInputStream getStreamModel(PpsBlockModel ppsBlockModel) {
        return new SimpleOleInputStream(ppsBlockModel, this.bbdModel, this.blocks);
    }
}

