/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.ui;

import de.javasoft.combobox.JYComboBox;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.plaf.basic.SpinningCalendarHeaderHandler;

public class MonthViewCalendarHeaderHandler
extends SpinningCalendarHeaderHandler {
    protected MonthViewCalendarHeader createCalendarHeader() {
        MonthViewCalendarHeader header = new MonthViewCalendarHeader();
        if (Boolean.TRUE.equals(UIManager.getBoolean("SpinningCalendarHeader.focusableSpinnerText"))) {
            header.setSpinnerFocusable(true);
        }
        if (Boolean.TRUE.equals(UIManager.getBoolean("SpinningCalendarHeader.arrowsSurroundMonth"))) {
            header.setArrowsSurroundMonth(true);
        }
        return header;
    }

    private boolean setMonth(int month) {
        Calendar cal = this.monthView.getCalendar();
        if (cal.get(2) == month) {
            return false;
        }
        cal.set(2, month);
        this.monthView.setFirstDisplayedDay(cal.getTime());
        return true;
    }

    private static class MonthComboBoxRenderer
    implements ListCellRenderer<Object> {
        private ListCellRenderer<Object> defaultRenderer;
        private JYComboBox combo;
        private Color monthForeground = UIManager.getColor("JXMonthView.monthStringForeground");
        private Color foreground = UIManager.getColor("ComboBox.foreground");
        private Color focusedForeground = SyntheticaLookAndFeel.getColor((String)"Synthetica.comboBox.focused.textColor", (Component)this.combo, (Color)this.monthForeground);

        public MonthComboBoxRenderer(JYComboBox combo, ListCellRenderer<Object> defaultRenderer) {
            this.combo = combo;
            this.defaultRenderer = defaultRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index < 0) {
                if (this.foreground.equals(this.focusedForeground) || !this.combo.hasFocus()) {
                    this.combo.setForeground(new Color(this.monthForeground.getRGB()));
                } else if (this.combo.hasFocus()) {
                    this.combo.setForeground(new Color(this.focusedForeground.getRGB()));
                }
            }
            if (index >= 0 && !isSelected) {
                l.setForeground(this.monthForeground);
            }
            return l;
        }
    }

    protected class MonthViewCalendarHeader
    extends SpinningCalendarHeaderHandler.SpinningCalendarHeader {
        private AbstractButton prevButton;
        private AbstractButton nextButton;
        private JLabel monthText;
        private JYComboBox monthCombo;
        private JSpinner yearSpinner;
        private boolean surroundMonth;

        public MonthViewCalendarHeader() {
            this.initComponents();
        }

        public void setActions(Action prev, Action next, SpinnerModel model) {
            this.prevButton.setAction(prev);
            this.nextButton.setAction(next);
            this.uninstallZoomAction();
            this.installZoomAction(model);
        }

        public void setSpinnerFocusable(boolean focusable) {
            ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFocusable(focusable);
        }

        public void setArrowsSurroundMonth(boolean surroundMonth) {
            if (this.surroundMonth == surroundMonth) {
                return;
            }
            this.surroundMonth = surroundMonth;
            this.removeAll();
            this.addComponents();
        }

        public void setMonthText(String text) {
            this.monthText.setText(text);
            this.monthCombo.setSelectedItem(text);
        }

        public void setFont(Font font) {
            super.setFont(font);
            if (this.monthText != null) {
                this.monthText.setFont(font);
                this.monthCombo.setFont(font);
                this.yearSpinner.setFont(font);
                this.yearSpinner.getEditor().setFont(font);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFont(font);
            }
        }

        public void setBackground(Color bg) {
            super.setBackground(bg);
            int i = 0;
            while (i < this.getComponentCount()) {
                this.getComponent(i).setBackground(bg);
                ++i;
            }
            if (this.yearSpinner != null) {
                this.yearSpinner.setBackground(bg);
                this.yearSpinner.getEditor().setBackground(bg);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setBackground(bg);
            }
        }

        private void installZoomAction(SpinnerModel model) {
            if (model == null) {
                return;
            }
            this.yearSpinner.setModel(model);
        }

        private void uninstallZoomAction() {
        }

        private void initComponents() {
            this.createComponents();
            this.setLayout(new BoxLayout((Container)((Object)this), 2));
            this.setBorder(HiDpi.createEmptyBorder((int)2, (int)4, (int)2, (int)4, (boolean)true));
            this.addComponents();
        }

        private void addComponents() {
            if (this.surroundMonth) {
                this.add(this.prevButton);
                this.add(this.monthCombo);
                this.add(this.nextButton);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
            } else {
                this.add(this.prevButton);
                this.add(Box.createHorizontalGlue());
                this.add(this.monthCombo);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
                this.add(Box.createHorizontalGlue());
                this.add(this.nextButton);
            }
        }

        private void createComponents() {
            this.prevButton = this.createNavigationButton();
            this.nextButton = this.createNavigationButton();
            this.monthText = this.createMonthText();
            this.monthCombo = this.createMonthCombo();
            this.yearSpinner = this.createSpinner();
        }

        private JLabel createMonthText() {
            JLabel comp = new JLabel(){

                @Override
                public Dimension getMaximumSize() {
                    Dimension dim = super.getMaximumSize();
                    dim.width = Integer.MAX_VALUE;
                    dim.height = Integer.MAX_VALUE;
                    return dim;
                }
            };
            comp.setHorizontalAlignment(0);
            return comp;
        }

        private JYComboBox createMonthCombo() {
            Locale current = this.getLocale();
            String[] monthNames = DateFormatSymbols.getInstance(current).getMonths();
            JYComboBox<String> combo = new JYComboBox<String>((T[])monthNames);
            combo.removeItemAt(12);
            combo.setMaximumRowCount(12);
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JComboBox c = (JComboBox)evt.getSource();
                    int month = c.getSelectedIndex();
                    if (MonthViewCalendarHeaderHandler.this.monthView != null) {
                        MonthViewCalendarHeaderHandler.this.setMonth(month);
                    }
                }
            });
            combo.setRenderer(new MonthComboBoxRenderer(combo, combo.getRenderer()));
            return combo;
        }

        private JSpinner createSpinner() {
            JSpinner spinner = new JSpinner();
            spinner.setFocusable(false);
            spinner.setBorder(BorderFactory.createEmptyBorder());
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
            editor.getFormat().setGroupingUsed(false);
            editor.getTextField().setFocusable(false);
            spinner.setEditor(editor);
            return spinner;
        }

        private AbstractButton createNavigationButton() {
            JXHyperlink b = new JXHyperlink();
            b.setContentAreaFilled(false);
            b.setBorder(BorderFactory.createEmptyBorder());
            b.setRolloverEnabled(true);
            b.setFocusable(false);
            return b;
        }
    }
}

