/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.ui.controls;

import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.IPopupComponentInitializer;
import de.javasoft.combobox.ui.painter.JYComboBoxPainter;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ComponentPopup
extends BasicComboPopup
implements AWTEventListener,
WindowListener {
    private static final long serialVersionUID = 7196620101607920884L;
    private int preferredWidth;
    private int preferredHeight;
    private boolean resizable;
    private boolean sizeRestorable;
    private int dragStartX;
    private int dragStartY;
    private Rectangle dragBounds;
    private boolean openLocked;
    private static ArrayList<ComponentPopup> popupList = new ArrayList();
    private static String ANCESTOR_CHANGED_KEY = "JYComboBox.ancestorChanged";

    public ComponentPopup(JComboBox<Object> combo) {
        super(combo);
    }

    private boolean isComboListPopup() {
        return this.scroller.getViewport().getView() == this.list;
    }

    private boolean isPopupFocusable() {
        return !this.isComboListPopup();
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public void setPreferredHeight(int height) {
        this.preferredHeight = height;
    }

    public void setPopupComponent(JComponent c) {
        this.configureScroller();
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        SyntheticaLookAndFeel.findComponent((String)"JYComboBox.ResizeHandle", (Container)this).setVisible(resizable);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setSizeRestorable(boolean restorable) {
        this.sizeRestorable = restorable;
    }

    public boolean isSizeRestorable() {
        return this.sizeRestorable;
    }

    @Override
    public Dimension getPreferredSize() {
        int popupWidth;
        SynthContext sc;
        SynthStyle ss;
        Insets insets;
        int w = 0;
        int h = 0;
        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel && !((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"JComboBox.isTableCellEditor", (JComponent)this.comboBox, (Object)false)).booleanValue() && (insets = (Insets)(ss = SynthLookAndFeel.getStyle(this.comboBox, Region.COMBO_BOX)).get(sc = new SynthContext(this.comboBox, Region.COMBO_BOX, ss, 0), "ComboBox.popupInsets")) != null) {
            w -= insets.left + insets.right;
            h -= insets.top + insets.bottom;
        }
        if ((popupWidth = ((JYComboBox)this.comboBox).getPopupWidth()) > 0 && !this.sizeRestorable) {
            this.preferredWidth = popupWidth;
        } else if (this.preferredWidth <= 0 || !this.sizeRestorable) {
            this.preferredWidth = w + (this.isComboListPopup() ? super.getPreferredSize().width : this.scroller.getViewport().getView().getPreferredSize().width + this.getInsets().left + this.getInsets().right);
        }
        int popupHeight = ((JYComboBox)this.comboBox).getPopupHeight();
        if (popupHeight > 0 && !this.sizeRestorable) {
            this.preferredHeight = popupHeight;
        } else if (this.preferredHeight <= 0 || !this.sizeRestorable) {
            this.preferredHeight = h + (this.isComboListPopup() ? super.getPreferredSize().height : this.scroller.getViewport().getView().getPreferredSize().height + this.getInsets().top + this.getInsets().bottom);
            if (this.resizable && !this.isComboListPopup()) {
                this.preferredHeight += SyntheticaLookAndFeel.findComponent((String)"JYComboBox.ResizeHandle", (Container)this).getPreferredSize().height;
            }
        }
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
        this.installListListeners();
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(this.scroller);
        this.add((Component)this.createResizeHandle(), "South");
        JYComboBox combo = (JYComboBox)this.comboBox;
        this.setPreferredWidth(combo.getPopupWidth());
        this.setPreferredHeight(combo.getPopupHeight());
        this.setResizable(combo.isPopupResizable());
        this.setSizeRestorable(combo.isPopupSizeRestorable());
    }

    @Override
    public void show(Component invoker, int x, int y) {
        SynthContext sc;
        SynthStyle ss;
        Insets insets;
        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel && !((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"JComboBox.isTableCellEditor", (JComponent)((JComponent)invoker), (Object)false)).booleanValue() && (insets = (Insets)(ss = SynthLookAndFeel.getStyle((JComponent)invoker, Region.COMBO_BOX)).get(sc = new SynthContext((JComponent)invoker, Region.COMBO_BOX, ss, 0), "ComboBox.popupInsets")) != null) {
            x += insets.left;
            y += insets.top;
        }
        super.show(invoker, x, y);
    }

    protected JComponent createResizeHandle() {
        JPanel p = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = -6512380715333168624L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                    JYComboBoxPainter.getInstance().paintResizeHandle(ComponentPopup.this.comboBox, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight());
                } else {
                    int x = 1;
                    int y = 2;
                    int w = this.getWidth();
                    g.setColor(new Color(0xC0C0C0));
                    g.drawLine(x, y, x + w - 2 * x - 1, y);
                    g.drawLine(x, y + 2, x + w - 2 * x - 1, y + 2);
                }
            }
        };
        int size = SyntheticaLookAndFeel.getInt((String)"JYComboBox.resizeHandle.size", (Component)this.comboBox, (int)7, (boolean)true);
        p.setPreferredSize(new Dimension(0, size));
        p.setName("JYComboBox.ResizeHandle");
        p.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYComboBox.resizeHandle.opaque", (Component)this.comboBox, (boolean)true));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Point mouseOnScreen = evt.getPoint();
                SwingUtilities.convertPointToScreen(mouseOnScreen, evt.getComponent());
                ComponentPopup.this.dragStartX = mouseOnScreen.x;
                ComponentPopup.this.dragStartY = mouseOnScreen.y;
                Window w = SwingUtilities.getWindowAncestor(evt.getComponent());
                ComponentPopup.this.dragBounds = w.getBounds();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                evt.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        };
        p.addMouseListener(mouseListener);
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                Component c = evt.getComponent();
                Rectangle bounds = c.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                bounds.width -= SyntheticaLookAndFeel.getInt((String)"JYComboBox.resizeHandle.edgeSize", (Component)ComponentPopup.this.comboBox, (int)16, (boolean)true);
                boolean vResize = bounds.contains(evt.getPoint());
                c.setCursor(new Cursor(vResize ? 9 : 5));
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                Component c = evt.getComponent();
                boolean vResize = c.getCursor().getType() == 9;
                Point mouseOnScreen = evt.getPoint();
                SwingUtilities.convertPointToScreen(mouseOnScreen, c);
                int dx = vResize ? 0 : mouseOnScreen.x - ComponentPopup.this.dragStartX;
                int dy = mouseOnScreen.y - ComponentPopup.this.dragStartY;
                Window w = SwingUtilities.getWindowAncestor(evt.getComponent());
                w.setBounds(((ComponentPopup)ComponentPopup.this).dragBounds.x, ((ComponentPopup)ComponentPopup.this).dragBounds.y, ((ComponentPopup)ComponentPopup.this).dragBounds.width + dx, ((ComponentPopup)ComponentPopup.this).dragBounds.height + dy);
                ComponentPopup.this.preferredWidth = ((ComponentPopup)ComponentPopup.this).dragBounds.width + dx;
                ComponentPopup.this.preferredHeight = ((ComponentPopup)ComponentPopup.this).dragBounds.height + dy;
            }
        };
        p.addMouseMotionListener(mouseMotionListener);
        return p;
    }

    @Override
    protected JScrollPane createScroller() {
        return new JScrollPane();
    }

    @Override
    protected void configureScroller() {
        JComponent c;
        super.configureScroller();
        if (this.scroller.getName() == null) {
            this.scroller.setName("ComboBox.scrollPane");
        }
        if ((c = ((JYComboBox)this.comboBox).getPopupComponent()) == null) {
            c = this.list;
        }
        this.scroller.setHorizontalScrollBarPolicy(c == this.list ? 31 : 30);
        this.scroller.setViewportView(c);
        if (c != this.list) {
            this.scroller.getHorizontalScrollBar().setFocusable(false);
        }
        this.scroller.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        boolean opaque = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"JYComboBox.scrollPane.opaque", (JComponent)c, (Object)true);
        this.scroller.setOpaque(opaque);
        this.scroller.getViewport().setOpaque(opaque);
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.installHandler();
        } else {
            this.uninstallHandler();
        }
    }

    private boolean isPressedWithinPopup(ComponentPopup popup, MouseEvent me) {
        if (!popup.isShowing()) {
            return false;
        }
        Point loc = popup.getLocationOnScreen();
        Rectangle screenBounds = new Rectangle(loc.x, loc.y, popup.getWidth(), popup.getHeight());
        Point p = me.getPoint();
        SwingUtilities.convertPointToScreen(p, me.getComponent());
        return screenBounds.contains(p);
    }

    private void installHandler() {
        if (this.openLocked && !(this.comboBox.getParent() instanceof JTable)) {
            return;
        }
        Component view = this.scroller.getViewport().getView();
        if (view instanceof IPopupComponentInitializer) {
            ((IPopupComponentInitializer)((Object)view)).initializePopupComponent((JYComboBox)this.comboBox);
        }
        popupList.add(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        if (popupList.size() == 1) {
            SwingUtilities.getWindowAncestor(this.comboBox).addWindowListener(this);
        }
        super.setVisible(true);
        if (this.isPopupFocusable()) {
            Window w = SwingUtilities.getWindowAncestor(this);
            w.setName("###focusableSwingPopup###");
            w.setFocusableWindowState(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component defaultFocusComponent = FocusManager.getCurrentManager().getDefaultFocusTraversalPolicy().getDefaultComponent(ComponentPopup.this);
                if (ComponentPopup.this.isPopupFocusable() && defaultFocusComponent != null) {
                    defaultFocusComponent.requestFocus();
                }
            }
        });
    }

    private void uninstallHandler() {
        boolean ancestorChanged;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        Window w = SwingUtilities.getWindowAncestor(this.comboBox);
        if (w != null) {
            w.removeWindowListener(this);
        }
        if ((ancestorChanged = ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)ANCESTOR_CHANGED_KEY, (JComponent)this.comboBox, (Object)false)).booleanValue()) && !((JYComboBox)this.comboBox).getClearMenuSelectionOnAncestorChange()) {
            this.comboBox.putClientProperty(ANCESTOR_CHANGED_KEY, false);
        } else {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.setVisible(false);
        popupList.remove(this);
    }

    @Override
    public void eventDispatched(AWTEvent evt) {
        if (evt.getID() == 401) {
            KeyEvent ke = (KeyEvent)evt;
            if (popupList.isEmpty() || popupList.get(popupList.size() - 1) != this) {
                return;
            }
            int code = ke.getKeyCode();
            if (code == 27 || !this.isPopupFocusable() && code == 10 || !this.isPopupFocusable() && code == 9) {
                if (code == 27 || code == 9) {
                    this.firePopupMenuCanceled();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComponentPopup.this.setVisible(false);
                    }
                });
            }
        }
        if (evt.getID() == 501) {
            MouseEvent me = (MouseEvent)evt;
            Component c = me.getComponent();
            if (this.isShowing()) {
                boolean inAnyPopup = false;
                for (ComponentPopup popup : popupList) {
                    inAnyPopup |= this.isPressedWithinPopup(popup, me);
                }
                if (inAnyPopup) {
                    boolean popupComponent;
                    if (popupList.isEmpty() || popupList.get(popupList.size() - 1) != this) {
                        return;
                    }
                    if (this.isPressedWithinPopup(this, me) && !this.isComboListPopup()) {
                        return;
                    }
                    if (this.isComboListPopup() && (popupComponent = SwingUtilities.isDescendingFrom(c, this))) {
                        if (c != this.list) {
                            return;
                        }
                        this.comboBox.setSelectedIndex(this.list.getSelectedIndex());
                    }
                } else {
                    if ((c == this.comboBox || "ComboBox.arrowButton".equals(c.getName())) && this.comboBox.getParent() instanceof JTable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ComponentPopup.this.setVisible(false);
                            }
                        });
                        return;
                    }
                    this.firePopupMenuCanceled();
                }
            }
            this.openLocked = true;
            this.setVisible(false);
            boolean closeByArrowButton = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"JYComboBox.closePopupByArrowButton", (JComponent)this.comboBox, (Object)true);
            if (closeByArrowButton) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComponentPopup.this.openLocked = false;
                    }
                });
            } else {
                this.openLocked = false;
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
        this.setVisible(false);
    }
}

