/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.searchfield;

import de.javasoft.searchfield.JYSearchField;
import de.javasoft.textfield.IFormattedField;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class JYFormattedSearchField
extends JYSearchField
implements IFormattedField {
    private static final long serialVersionUID = -8421185207171009986L;

    public JYFormattedSearchField() {
    }

    public JYFormattedSearchField(Object value) {
        this();
        this.setValue(value);
    }

    public JYFormattedSearchField(Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format));
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object type) {
        if (type instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)type));
        }
        if (type instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)type));
        }
        if (type instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)type));
        }
        if (type instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (type instanceof Number) {
            NumberFormatter displayFormatter = new NumberFormatter();
            displayFormatter.setValueClass(type.getClass());
            NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat("#.#"));
            editFormatter.setValueClass(type.getClass());
            return new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    public JYFormattedSearchField(JFormattedTextField.AbstractFormatter formatter) {
        this(new DefaultFormatterFactory(formatter));
    }

    public JYFormattedSearchField(JFormattedTextField.AbstractFormatterFactory factory) {
        this();
        this.setFormatterFactory(factory);
    }
}

