/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import de.javasoft.tabpane.ui.JYTabbedPaneUI;
import de.javasoft.tabpane.ui.addons.JYTabbedPaneAddon;
import de.javasoft.tabpane.ui.controls.ICloseButtonStrategy;
import de.javasoft.tabpane.ui.controls.Tab;
import de.javasoft.tabpane.ui.painter.JYTabbedPanePainter;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JYTabbedPane
extends JTabbedPane
implements IUIPropertySupport {
    private static final long serialVersionUID = 4072790590414750617L;
    public static final String uiClassID = "JYTabbedPaneUI";
    private JPanel contentPanel;
    private JComponent leadingTabAreaComponent;
    private JComponent trailingTabAreaComponent;
    private UIValue<Boolean> paintSelectedTabBold;
    private UIValue<Integer> tabGap;
    private UIValue<Integer> hTabAlign;
    private UIValue<Integer> vTabAlign;
    private UIValue<TabControlsShowStrategy> tabControlsShowStrategy;
    private UIValue<TabControlsPosition> tabControlsPosition;
    private UIValue<Boolean> showScrollButtons;
    private UIValue<Boolean> showPopupButton;
    private UIValue<Boolean> overlapTabsInvers;
    private UIValue<ICloseButtonStrategy> closeButtonStrategy;
    private UIValue<TabStyle> tabStyle;
    private UIValue<Boolean> tabScrollAnimationEnabled;
    private UIValue<Boolean> tabReorderByDraggingEnabled;
    private UIValue<Integer> minimumTabSize;
    private UIValue<Integer> maximumTabSize;
    private UIValue<Boolean> tabsStretchedEnabled;
    private UIValue<Boolean> tabRotationEnabled;
    private UIValue<Boolean> showPlusButton;
    private UIValue<Boolean> tabOverviewEnabled;
    private UIValue<Boolean> tabPreviewOnHoverEnabled;
    private boolean tabsEditable;
    private boolean tabsFocusable = true;
    private TabHistoryHandler tabHistoryHandler;
    private boolean tabRemove;
    private boolean tabInsert;
    private boolean tabMove;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTabbedPaneAddon());
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYTabbedPaneUI.class));
    }

    @Override
    public Component add(Component component) {
        return super.add(component);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof UIResource)) {
            this.getContentPanel().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new ContentPanel();
        }
        return this.contentPanel;
    }

    public void setLeadingTabAreaComponent(JComponent c) {
        if (c != this.leadingTabAreaComponent) {
            JComponent oldVal = this.leadingTabAreaComponent;
            this.leadingTabAreaComponent = c;
            this.firePropertyChange("leadingTabAreaComponent", oldVal, c);
        }
    }

    public JComponent getLeadingTabAreaComponent() {
        return this.leadingTabAreaComponent;
    }

    public void setTrailingTabAreaComponent(JComponent c) {
        if (c != this.trailingTabAreaComponent) {
            JComponent oldVal = this.trailingTabAreaComponent;
            this.trailingTabAreaComponent = c;
            this.firePropertyChange("trailingTabAreaComponent", oldVal, c);
        }
    }

    public JComponent getTrailingTabAreaComponent() {
        return this.trailingTabAreaComponent;
    }

    public void moveTab(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        this.tabMove = true;
        String title = this.getTitleAt(oldIndex);
        Icon icon = this.getIconAt(oldIndex);
        Component c = this.getComponentAt(oldIndex);
        String toolTip = this.getToolTipTextAt(oldIndex);
        boolean enabled = this.isEnabledAt(oldIndex);
        int mnemonic = this.getMnemonicAt(oldIndex);
        Component tabComponent = this.getTabComponentAt(oldIndex);
        JLabel label = this.getTabLabelAt(oldIndex);
        int hTextPos = label == null ? 0 : label.getHorizontalTextPosition();
        int vTextPos = label == null ? 0 : label.getVerticalTextPosition();
        int hTextAlign = label == null ? 0 : label.getHorizontalAlignment();
        int vTextAlign = label == null ? 0 : label.getVerticalAlignment();
        Color oldBackground = this.getTabBackground(oldIndex);
        Float oldAlpha = this.getTabAlpha(oldIndex);
        this.removeTabAt(oldIndex);
        this.insertTab(title, icon, c, toolTip, newIndex);
        this.setEnabledAt(newIndex, enabled);
        this.setSelectedIndex(enabled ? newIndex : oldIndex);
        this.setMnemonicAt(newIndex, mnemonic);
        this.setTabComponentAt(newIndex, tabComponent);
        label = this.getTabLabelAt(newIndex);
        if (label != null) {
            label.setHorizontalTextPosition(hTextPos);
            label.setVerticalTextPosition(vTextPos);
            label.setHorizontalAlignment(hTextAlign);
            label.setVerticalAlignment(vTextAlign);
        }
        this.setTabBackground(oldBackground, oldAlpha, newIndex);
        this.tabMove = false;
        if (this.isTabHistoryEnabled()) {
            this.tabHistoryHandler.updateSelectedIndex(this.getSelectedIndex());
        }
    }

    public void setTabBackgroundAt(Color background, int tabIndex) {
        float alpha = (float)background.getAlpha() / 255.0f;
        this.setTabBackground(new Color(background.getRGB() & 0xFFFFFF), Float.valueOf(alpha), tabIndex);
    }

    public Color getTabBackgroundAt(int tabIndex) {
        Color color = this.getTabBackground(tabIndex);
        float alpha = this.getTabAlpha(tabIndex).floatValue();
        return new Color((int)(255.0f * alpha) << 24 | 0xFFFFFF & color.getRGB(), true);
    }

    private void setTabBackground(Color color, Float alpha, int tabIndex) {
        this.putClientProperty("Synthetica.tabbedPane.tab." + tabIndex + ".background", color);
        this.putClientProperty("Synthetica.tabbedPane.tab." + tabIndex + ".background.alpha", alpha);
    }

    private Color getTabBackground(int tabIndex) {
        return (Color)this.getClientProperty("Synthetica.tabbedPane.tab." + tabIndex + ".background");
    }

    private Float getTabAlpha(int tabIndex) {
        return (Float)this.getClientProperty("Synthetica.tabbedPane.tab." + tabIndex + ".background.alpha");
    }

    public void setSelectedIndex(final int index, boolean scrollToVisible) {
        this.setSelectedIndex(index);
        if (scrollToVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Action a = JYTabbedPane.this.getActionMap().get("scrollTabIndexToVisible");
                    a.actionPerformed(new ActionEvent(this, 1001, String.valueOf(index)));
                }
            });
        }
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        this.tabInsert = true;
        int i = this.getTabCount();
        while (i > index) {
            Color color = this.getTabBackground(i - 1);
            Float alpha = this.getTabAlpha(i - 1);
            this.setTabBackground(color, alpha, i);
            --i;
        }
        this.setTabBackground(null, null, index);
        int removeIndex = this.indexOfComponent(component);
        super.insertTab(title, icon, component, tip, index);
        if (component != null && removeIndex != -1 && index > removeIndex) {
            --index;
        }
        this.firePropertyChange("insertTab", null, (Object)index);
        this.tabInsert = false;
        if (this.isTabHistoryEnabled()) {
            this.tabHistoryHandler.updateSelectedIndex(this.getSelectedIndex());
        }
    }

    @Override
    public void setComponentAt(int index, Component component) {
        Component c = this.getComponentAt(index);
        if (c != null) {
            this.getContentPanel().remove(c);
        }
        super.setComponentAt(index, component);
    }

    @Override
    public void removeTabAt(int index) {
        this.tabRemove = true;
        int i = index;
        while (i < this.getTabCount() - 1) {
            Color color = this.getTabBackground(i + 1);
            Float alpha = this.getTabAlpha(i + 1);
            this.setTabBackground(color, alpha, i);
            ++i;
        }
        this.setTabBackground(null, null, this.getTabCount() - 1);
        Component c = this.getComponentAt(index);
        super.removeTabAt(index);
        if (c != null) {
            this.getContentPanel().remove(c);
            c.setVisible(true);
        }
        this.firePropertyChange("removeTab", null, (Object)index);
        this.tabRemove = false;
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        this.firePropertyChange("title", -1, index);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        this.firePropertyChange("icon", -1, index);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        super.setToolTipTextAt(index, toolTipText);
        this.firePropertyChange("toolTipText", -1, index);
    }

    @Override
    public void setMnemonicAt(int tabIndex, int mnemonic) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(mnemonic, 512), "setSelectedTabIndex");
        this.getTabLabelAt(tabIndex).setDisplayedMnemonic(mnemonic);
        super.setMnemonicAt(tabIndex, mnemonic);
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public JLabel getTabLabelAt(int index) {
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.getTabsPanel();
        Tab tab = tabsPanel.getTab(index);
        return tab == null ? null : (tab.getComponent() instanceof JLabel ? (JLabel)tab.getComponent() : null);
    }

    public void setTabVisible(int index, boolean visible) {
        if (!visible && this.getSelectedIndex() == index) {
            this.setSelectedIndex(index + 1 < this.getTabCount() ? index + 1 : index - 1);
        }
        this.getTabsPanel().getTab(index).setVisible(visible);
    }

    public boolean isTabVisible(int index) {
        return this.getTabsPanel().getTab(index).isVisible();
    }

    public void setTabsEditable(boolean editable) {
        boolean oldValue = this.tabsEditable;
        this.tabsEditable = editable;
        this.firePropertyChange("tabsEditable", oldValue, editable);
    }

    public boolean getTabsEditable() {
        return this.tabsEditable;
    }

    public void setTabsFocusable(boolean focusable) {
        boolean oldValue = this.tabsFocusable;
        this.tabsFocusable = focusable;
        this.firePropertyChange("tabsFocusable", oldValue, focusable);
    }

    public boolean getTabsFocusable() {
        return this.tabsFocusable;
    }

    public void setTabHistoryEnabled(boolean enabled) {
        boolean oldValue = this.isTabHistoryEnabled();
        if (oldValue == enabled) {
            return;
        }
        if (enabled) {
            this.tabHistoryHandler = new TabHistoryHandler();
            this.addPropertyChangeListener(this.tabHistoryHandler);
            this.addChangeListener(this.tabHistoryHandler);
        } else {
            this.removePropertyChangeListener(this.tabHistoryHandler);
            this.removeChangeListener(this.tabHistoryHandler);
            this.tabHistoryHandler = null;
        }
        this.firePropertyChange("tabHistoryEnabled", oldValue, enabled);
    }

    public boolean isTabHistoryEnabled() {
        return this.tabHistoryHandler != null;
    }

    public static void setAllNonOpaque(Container container) {
        TabbedPanePainter.setAllNonOpaque((Container)container);
    }

    public void setPaintSelectedTabBold(Boolean bold) {
        this.setPaintSelectedTabBold(bold, false);
    }

    public void setPaintSelectedTabBold(Boolean bold, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "paintSelectedTabBold", this.paintSelectedTabBold, this.getPaintSelectedTabBold(), bold, isUIResource, true, true);
    }

    public boolean paintSelectedTabBoldIsUIResource() {
        return this.getPaintSelectedTabBoldUIValue().isUIResource();
    }

    public Boolean getPaintSelectedTabBold() {
        return this.getPaintSelectedTabBoldUIValue().get();
    }

    private UIValue<Boolean> getPaintSelectedTabBoldUIValue() {
        if (this.paintSelectedTabBold == null) {
            this.paintSelectedTabBold = new UIValue();
        }
        return this.paintSelectedTabBold;
    }

    public void setTabGap(Integer gap) {
        this.setTabGap(gap, false);
    }

    public void setTabGap(Integer gap, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabGap", this.tabGap, this.getTabGap(), gap, isUIResource, false, false);
    }

    public boolean tabGapIsUIResource() {
        return this.getTabGapUIValue().isUIResource();
    }

    public Integer getTabGap() {
        return this.getTabGapUIValue().get();
    }

    private UIValue<Integer> getTabGapUIValue() {
        if (this.tabGap == null) {
            this.tabGap = new UIValue();
        }
        return this.tabGap;
    }

    public void setHorizontalTabAlignment(Integer alignment) {
        this.setHorizontalTabAlignment(alignment, false);
    }

    public void setHorizontalTabAlignment(Integer alignment, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "horizontalTabAlignment", this.hTabAlign, this.getHorizontalTabAlignment(), alignment, isUIResource, false, false);
    }

    public boolean horizontalTabAlignmentIsUIResource() {
        return this.getHorizontalTabAlignmentUIValue().isUIResource();
    }

    public Integer getHorizontalTabAlignment() {
        return this.getHorizontalTabAlignmentUIValue().get();
    }

    private UIValue<Integer> getHorizontalTabAlignmentUIValue() {
        if (this.hTabAlign == null) {
            this.hTabAlign = new UIValue();
        }
        return this.hTabAlign;
    }

    public void setVerticalTabAlignment(Integer alignment) {
        this.setVerticalTabAlignment(alignment, false);
    }

    public void setVerticalTabAlignment(Integer alignment, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "verticalTabAlignment", this.vTabAlign, this.getVerticalTabAlignment(), alignment, isUIResource, false, false);
    }

    public boolean verticalTabAlignmentIsUIResource() {
        return this.getVerticalTabAlignmentUIValue().isUIResource();
    }

    public Integer getVerticalTabAlignment() {
        return this.getVerticalTabAlignmentUIValue().get();
    }

    private UIValue<Integer> getVerticalTabAlignmentUIValue() {
        if (this.vTabAlign == null) {
            this.vTabAlign = new UIValue();
        }
        return this.vTabAlign;
    }

    public void setTabControlsShowStrategy(TabControlsShowStrategy strategy) {
        this.setTabControlsShowStrategy(strategy, false);
    }

    public void setTabControlsShowStrategy(TabControlsShowStrategy strategy, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabControlsShowStrategy", this.tabControlsShowStrategy, this.getTabControlsShowStrategy(), strategy, isUIResource, true, true);
    }

    public boolean tabControlsShowStrategyIsUIResource() {
        return this.getTabControlsShowStrategyUIValue().isUIResource();
    }

    public TabControlsShowStrategy getTabControlsShowStrategy() {
        return this.getTabControlsShowStrategyUIValue().get();
    }

    private UIValue<TabControlsShowStrategy> getTabControlsShowStrategyUIValue() {
        if (this.tabControlsShowStrategy == null) {
            this.tabControlsShowStrategy = new UIValue();
        }
        return this.tabControlsShowStrategy;
    }

    public void setTabControlsPosition(TabControlsPosition position) {
        this.setTabControlsPosition(position, false);
    }

    public void setTabControlsPosition(TabControlsPosition position, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabControlsPosition", this.tabControlsPosition, this.getTabControlsPosition(), position, isUIResource, false, false);
    }

    public boolean tabControlsPositionIsUIResource() {
        return this.getTabControlsPositionUIValue().isUIResource();
    }

    public TabControlsPosition getTabControlsPosition() {
        return this.getTabControlsPositionUIValue().get();
    }

    private UIValue<TabControlsPosition> getTabControlsPositionUIValue() {
        if (this.tabControlsPosition == null) {
            this.tabControlsPosition = new UIValue();
        }
        return this.tabControlsPosition;
    }

    public void setTabStyle(TabStyle style) {
        this.setTabStyle(style, false);
    }

    public void setTabStyle(TabStyle style, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabStyle", this.tabStyle, this.getTabStyle(), style, isUIResource, false, true);
    }

    public boolean tabStyleIsUIResource() {
        return this.getTabStyleUIValue().isUIResource();
    }

    public TabStyle getTabStyle() {
        return this.getTabStyleUIValue().get();
    }

    private UIValue<TabStyle> getTabStyleUIValue() {
        if (this.tabStyle == null) {
            this.tabStyle = new UIValue();
        }
        return this.tabStyle;
    }

    public void setShowScrollButtons(Boolean show) {
        this.setShowScrollButtons(show, false);
    }

    public void setShowScrollButtons(Boolean show, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "showScrollButtons", this.showScrollButtons, this.getShowScrollButtons(), show, isUIResource, false, false);
    }

    public boolean showScrollButtonsIsUIResource() {
        return this.getShowScrollButtonsUIValue().isUIResource();
    }

    public Boolean getShowScrollButtons() {
        return this.getShowScrollButtonsUIValue().get();
    }

    private UIValue<Boolean> getShowScrollButtonsUIValue() {
        if (this.showScrollButtons == null) {
            this.showScrollButtons = new UIValue();
        }
        return this.showScrollButtons;
    }

    public void setShowPopupButton(Boolean show) {
        this.setShowPopupButton(show, false);
    }

    public void setShowPopupButton(Boolean show, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "showPopupButton", this.showPopupButton, this.getShowPopupButton(), show, isUIResource, false, false);
    }

    public boolean showPopupButtonIsUIResource() {
        return this.getShowPopupButtonUIValue().isUIResource();
    }

    public Boolean getShowPopupButton() {
        return this.getShowPopupButtonUIValue().get();
    }

    private UIValue<Boolean> getShowPopupButtonUIValue() {
        if (this.showPopupButton == null) {
            this.showPopupButton = new UIValue();
        }
        return this.showPopupButton;
    }

    public void setOverlapTabsInvers(Boolean invers) {
        this.setOverlapTabsInvers(invers, false);
    }

    public void setOverlapTabsInvers(Boolean invers, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "overlapTabsInvers", this.overlapTabsInvers, this.getOverlapTabsInvers(), invers, isUIResource, false, true);
    }

    public boolean overlapTabsInversIsUIResource() {
        return this.getOverlapTabsInversUIValue().isUIResource();
    }

    public Boolean getOverlapTabsInvers() {
        return this.getOverlapTabsInversUIValue().get();
    }

    private UIValue<Boolean> getOverlapTabsInversUIValue() {
        if (this.overlapTabsInvers == null) {
            this.overlapTabsInvers = new UIValue();
        }
        return this.overlapTabsInvers;
    }

    public void setCloseButtonStrategy(ICloseButtonStrategy strategy) {
        this.setCloseButtonStrategy(strategy, false);
    }

    public void setCloseButtonStrategy(ICloseButtonStrategy strategy, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "closeButtonStrategy", this.closeButtonStrategy, this.getCloseButtonStrategy(), strategy, isUIResource, true, true);
    }

    public boolean closeButtonStrategyIsUIResource() {
        return this.getCloseButtonStrategyUIValue().isUIResource();
    }

    public ICloseButtonStrategy getCloseButtonStrategy() {
        return this.getCloseButtonStrategyUIValue().get();
    }

    private UIValue<ICloseButtonStrategy> getCloseButtonStrategyUIValue() {
        if (this.closeButtonStrategy == null) {
            this.closeButtonStrategy = new UIValue();
        }
        return this.closeButtonStrategy;
    }

    public void setTabScrollAnimationEnabled(Boolean enabled) {
        this.setTabScrollAnimationEnabled(enabled, false);
    }

    public void setTabScrollAnimationEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabScrollAnimationEnabled", this.tabScrollAnimationEnabled, this.getTabScrollAnimationEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabScrollAnimationEnabledIsUIResource() {
        return this.getTabScrollAnimationEnabledUIValue().isUIResource();
    }

    public Boolean getTabScrollAnimationEnabled() {
        return this.getTabScrollAnimationEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabScrollAnimationEnabledUIValue() {
        if (this.tabScrollAnimationEnabled == null) {
            this.tabScrollAnimationEnabled = new UIValue();
        }
        return this.tabScrollAnimationEnabled;
    }

    public void setTabReorderByDraggingEnabled(Boolean enabled) {
        this.setTabReorderByDraggingEnabled(enabled, false);
    }

    public void setTabReorderByDraggingEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabReorderByDraggingEnabled", this.tabReorderByDraggingEnabled, this.getTabReorderByDraggingEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabReorderByDraggingEnabledIsUIResource() {
        return this.getTabReorderByDraggingEnabledUIValue().isUIResource();
    }

    public Boolean getTabReorderByDraggingEnabled() {
        return this.getTabReorderByDraggingEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabReorderByDraggingEnabledUIValue() {
        if (this.tabReorderByDraggingEnabled == null) {
            this.tabReorderByDraggingEnabled = new UIValue();
        }
        return this.tabReorderByDraggingEnabled;
    }

    public void setMinimumTabSize(Integer size) {
        this.setMinimumTabSize(size, false);
    }

    public void setMinimumTabSize(Integer size, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "minimumTabSize", this.minimumTabSize, this.getMinimumTabSize(), size, isUIResource, false, false);
    }

    public boolean minimumTabSizeIsUIResource() {
        return this.getMinimumTabSizeUIValue().isUIResource();
    }

    public Integer getMinimumTabSize() {
        return this.getMinimumTabSizeUIValue().get();
    }

    private UIValue<Integer> getMinimumTabSizeUIValue() {
        if (this.minimumTabSize == null) {
            this.minimumTabSize = new UIValue();
        }
        return this.minimumTabSize;
    }

    public void setMaximumTabSize(Integer size) {
        this.setMaximumTabSize(size, false);
    }

    public void setMaximumTabSize(Integer size, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "maximumTabSize", this.maximumTabSize, this.getMaximumTabSize(), size, isUIResource, false, false);
    }

    public boolean maximumTabSizeIsUIResource() {
        return this.getMaximumTabSizeUIValue().isUIResource();
    }

    public Integer getMaximumTabSize() {
        return this.getMaximumTabSizeUIValue().get();
    }

    private UIValue<Integer> getMaximumTabSizeUIValue() {
        if (this.maximumTabSize == null) {
            this.maximumTabSize = new UIValue();
        }
        return this.maximumTabSize;
    }

    public void setTabsStretchedEnabled(Boolean enabled) {
        this.setTabsStretchedEnabled(enabled, false);
    }

    public void setTabsStretchedEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabsStretchedEnabled", this.tabsStretchedEnabled, this.getTabsStretchedEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabsStretchedEnabledIsUIResource() {
        return this.getTabsStretchedEnabledUIValue().isUIResource();
    }

    public Boolean getTabsStretchedEnabled() {
        return this.getTabsStretchedEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabsStretchedEnabledUIValue() {
        if (this.tabsStretchedEnabled == null) {
            this.tabsStretchedEnabled = new UIValue();
        }
        return this.tabsStretchedEnabled;
    }

    public void setTabRotationEnabled(Boolean enabled) {
        this.setTabRotationEnabled(enabled, false);
    }

    public void setTabRotationEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabRotationEnabled", this.tabRotationEnabled, this.getTabRotationEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabRotationEnabledIsUIResource() {
        return this.getTabRotationEnabledUIValue().isUIResource();
    }

    public Boolean getTabRotationEnabled() {
        return this.getTabRotationEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabRotationEnabledUIValue() {
        if (this.tabRotationEnabled == null) {
            this.tabRotationEnabled = new UIValue();
        }
        return this.tabRotationEnabled;
    }

    public void setShowPlusButton(Boolean show) {
        this.setShowPlusButton(show, false);
    }

    public void setShowPlusButton(Boolean show, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "showPlusButton", this.showPlusButton, this.getShowPlusButton(), show, isUIResource, false, false);
    }

    public boolean showPlusButtonIsUIResource() {
        return this.getShowPlusButtonUIValue().isUIResource();
    }

    public Boolean getShowPlusButton() {
        return this.getShowPlusButtonUIValue().get();
    }

    private UIValue<Boolean> getShowPlusButtonUIValue() {
        if (this.showPlusButton == null) {
            this.showPlusButton = new UIValue();
        }
        return this.showPlusButton;
    }

    public void setTabOverviewEnabled(Boolean enabled) {
        this.setTabOverviewEnabled(enabled, false);
    }

    public void setTabOverviewEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabOverviewEnabled", this.tabOverviewEnabled, this.getTabOverviewEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabOverviewEnabledIsUIResource() {
        return this.getTabOverviewEnabledUIValue().isUIResource();
    }

    public Boolean getTabOverviewEnabled() {
        return this.getTabOverviewEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabOverviewEnabledUIValue() {
        if (this.tabOverviewEnabled == null) {
            this.tabOverviewEnabled = new UIValue();
        }
        return this.tabOverviewEnabled;
    }

    public void setTabPreviewOnHoverEnabled(Boolean enabled) {
        this.setTabPreviewOnHoverEnabled(enabled, false);
    }

    public void setTabPreviewOnHoverEnabled(Boolean enabled, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "tabPreviewOnHoverEnabled", this.tabPreviewOnHoverEnabled, this.getTabPreviewOnHoverEnabled(), enabled, isUIResource, false, false);
    }

    public boolean tabPreviewOnHoverEnabledIsUIResource() {
        return this.getTabPreviewOnHoverEnabledUIValue().isUIResource();
    }

    public Boolean getTabPreviewOnHoverEnabled() {
        return this.getTabPreviewOnHoverEnabledUIValue().get();
    }

    private UIValue<Boolean> getTabPreviewOnHoverEnabledUIValue() {
        if (this.tabPreviewOnHoverEnabled == null) {
            this.tabPreviewOnHoverEnabled = new UIValue();
        }
        return this.tabPreviewOnHoverEnabled;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public boolean hasFocus() {
        BasicJYTabbedPaneUI.TabsPanel tabsPanel = this.getTabsPanel();
        if (tabsPanel != null) {
            Tab[] tabs;
            Tab[] tabArray = tabs = tabsPanel.getTabs().toArray(new Tab[0]);
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray[n2];
                if (tab.hasFocus()) {
                    return true;
                }
                ++n2;
            }
        }
        return super.hasFocus();
    }

    private BasicJYTabbedPaneUI.TabsPanel getTabsPanel() {
        return (BasicJYTabbedPaneUI.TabsPanel)SyntheticaLookAndFeel.findComponent(BasicJYTabbedPaneUI.TabsPanel.class, (Container)this);
    }

    public static enum CloseButtonStrategy implements ICloseButtonStrategy
    {
        NONE(null),
        SELECTED_TAB(new ICloseButtonStrategy(){

            @Override
            public boolean isButtonVisible(JYTabbedPane tabbedPane, Tab tab, boolean isOverview) {
                int selectedIndex = tabbedPane.getSelectedIndex();
                return selectedIndex >= 0 && selectedIndex == tab.getTabIndex();
            }
        }),
        SELECTED_TAB_OVERVIEW_ALL_TABS(new ICloseButtonStrategy(){

            @Override
            public boolean isButtonVisible(JYTabbedPane tabbedPane, Tab tab, boolean isOverview) {
                return isOverview ? ALL_TABS.isButtonVisible(tabbedPane, tab, isOverview) : SELECTED_TAB.isButtonVisible(tabbedPane, tab, isOverview);
            }
        }),
        ALL_TABS(new ICloseButtonStrategy(){

            @Override
            public boolean isButtonVisible(JYTabbedPane tabbedPane, Tab tab, boolean isOverview) {
                return true;
            }
        });

        private ICloseButtonStrategy strategy;

        private CloseButtonStrategy(ICloseButtonStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public boolean isButtonVisible(JYTabbedPane tabbedPane, Tab tab, boolean isOverview) {
            return this.strategy == null ? false : this.strategy.isButtonVisible(tabbedPane, tab, isOverview);
        }
    }

    private class ContentPanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = 3355882484839791206L;

        public ContentPanel() {
            this.setLayout(new BorderLayout(){

                @Override
                public void layoutContainer(Container target) {
                    super.layoutContainer(target);
                    Insets insets = target.getInsets();
                    int top = insets.top;
                    int bottom = target.getHeight() - insets.bottom;
                    int left = insets.left;
                    int right = target.getWidth() - insets.right;
                    Component[] componentArray = target.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        c.setBounds(left, top, right - left, bottom - top);
                        ++n2;
                    }
                }
            });
            this.setName("JYTabbedPane.ContentPanel");
        }

        @Override
        public void remove(Component c) {
            int index = JYTabbedPane.this.indexOfComponent(c);
            if (index != -1) {
                JYTabbedPane.this.removeTabAt(index);
            } else {
                Component[] componentArray = this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c_ = componentArray[n2];
                    if (c_ == c) {
                        super.remove(c);
                        break;
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void doLayout() {
            Component c;
            if (JYTabbedPane.this.getSelectedIndex() >= 0 && (c = JYTabbedPane.this.getComponentAt(JYTabbedPane.this.getSelectedIndex())) != null && c != ((BorderLayout)this.getLayout()).getLayoutComponent("Center")) {
                ((BorderLayout)this.getLayout()).addLayoutComponent(c, "Center");
            }
            super.doLayout();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                JYTabbedPane tabPane = JYTabbedPane.this;
                SynthStyle ss = SynthLookAndFeel.getStyle(tabPane, Region.TABBED_PANE_CONTENT);
                SynthContext sc = new SynthContext(tabPane, Region.TABBED_PANE_CONTENT, ss, 0);
                this.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(ss.getInsets(sc, null), false));
                this.setBackground(ss.getColor(sc, ColorType.BACKGROUND));
                this.setOpaque(ss.isOpaque(sc));
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            int selectedIndex;
            super.paintComponent(g);
            JYTabbedPane tabPane = JYTabbedPane.this;
            int placement = tabPane.getTabPlacement();
            if (!(placement != 2 && placement != 4 || tabPane.getComponentOrientation().isLeftToRight())) {
                placement = placement == 2 ? 4 : 2;
            }
            BasicJYTabbedPaneUI.TabsPanel tabsPanel = JYTabbedPane.this.getTabsPanel();
            BasicJYTabbedPaneUI.TabsPanelViewport tabsPanelViewport = (BasicJYTabbedPaneUI.TabsPanelViewport)tabsPanel.getParent();
            Rectangle vr = SwingUtilities.convertRectangle(tabsPanelViewport.getParent(), tabsPanelViewport.getBounds(), tabPane);
            if (tabsPanel.getShowPlusButton()) {
                tabsPanelViewport.calculatePlusButtonAwareViewRect(vr);
            }
            Rectangle r = (selectedIndex = tabPane.getSelectedIndex()) < 0 ? vr : SwingUtilities.convertRectangle(tabPane, vr.intersection(tabPane.getBoundsAt(selectedIndex)), this);
            tabPane.putClientProperty("JTabbedPane.visibleSelectedTabRect", selectedIndex < 0 || selectedIndex >= JYTabbedPane.this.getTabCount() ? null : r);
            int angle = ((BasicJYTabbedPaneUI)tabPane.getUI()).placementToRotation(placement).toAngle();
            SynthContext sc = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                sc = new SynthContext(tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(tabPane, Region.TABBED_PANE), 0);
            }
            boolean tabGap = ((BasicJYTabbedPaneUI)tabPane.getUI()).isPaintContentBorderGap4SelectedTabEnabled();
            JYTabbedPanePainter.getInstance(sc).paintTabbedPaneContentBorder(tabPane, new SyntheticaState(0), placement, tabGap, angle, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public static enum TabControlsPosition {
        LEADING,
        TRAILING,
        LEADING_TRAILING;

    }

    public static enum TabControlsShowStrategy {
        ALWAYS,
        NEVER,
        AS_NEEDED;

    }

    private class TabHistoryHandler
    implements PropertyChangeListener,
    ChangeListener {
        private ArrayList<Integer> tabHistory = new ArrayList();

        private TabHistoryHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JYTabbedPane tabPane = (JYTabbedPane)evt.getSource();
            String name = evt.getPropertyName();
            if ("removeTab".equals(name)) {
                int index = (Integer)evt.getNewValue();
                int i = this.tabHistory.size() - 1;
                while (i >= 0) {
                    Integer val = this.tabHistory.get(i);
                    if (index == val) {
                        this.tabHistory.remove(i);
                    } else if (val > index) {
                        this.tabHistory.remove(i);
                        this.tabHistory.add(i, val - 1);
                    }
                    --i;
                }
                int newSelected = this.tabHistory.size() > 0 ? this.tabHistory.get(this.tabHistory.size() - 1) : -1;
                int i2 = 1;
                while (i2 <= this.tabHistory.size() && !JYTabbedPane.this.isEnabledAt(newSelected)) {
                    newSelected = this.tabHistory.get(this.tabHistory.size() - i2);
                    ++i2;
                }
                if (newSelected >= 0) {
                    boolean scrollToTab = !JYTabbedPane.this.tabMove && SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabHistory.scrollToVisible", (Component)tabPane, (boolean)false);
                    tabPane.setSelectedIndex(newSelected, scrollToTab);
                }
                if (!JYTabbedPane.this.tabMove) {
                    this.updateSelectedIndex(tabPane.getSelectedIndex());
                }
            } else if ("insertTab".equals(name)) {
                int index = (Integer)evt.getNewValue();
                int i = this.tabHistory.size() - 1;
                while (i >= 0) {
                    Integer val = this.tabHistory.get(i);
                    if (val >= index && this.tabHistory.size() > 1) {
                        this.tabHistory.remove(i);
                        this.tabHistory.add(i, val + 1);
                    }
                    --i;
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane tabPane = (JTabbedPane)evt.getSource();
            if (!(JYTabbedPane.this.tabRemove || JYTabbedPane.this.tabMove || JYTabbedPane.this.tabInsert)) {
                this.updateSelectedIndex(tabPane.getSelectedIndex());
            }
        }

        private void updateSelectedIndex(int selectedIndex) {
            if (selectedIndex >= 0) {
                this.tabHistory.remove((Object)selectedIndex);
                this.tabHistory.add(selectedIndex);
            }
        }
    }

    public static enum TabStyle {
        COMMON,
        SELECTED_TAB_ONLY,
        TABS_ON_HOVER;

    }
}

