/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.JYCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class JYCheckBoxTree
extends JTree {
    private static final long serialVersionUID = 4472927255942543844L;
    private CheckBoxSelectionModel checkBoxSelectionModel;
    private boolean checkBoxSelectableByNodeClick;
    private boolean mousePressed;
    private Object clickedNode;
    private boolean checkBoxClicked;
    private int checkBoxWidth;

    public JYCheckBoxTree() {
        this(new DefaultMutableTreeNode("RootNode"));
    }

    public JYCheckBoxTree(TreeNode root) {
        super(root);
        this.setCheckBoxSelectableByNodeClick(true);
        this.setCheckBoxSelectionModel(new CheckBoxSelectionModel(this));
        CheckBoxRenderer r = new CheckBoxRenderer(this.getCellRenderer());
        this.setCellRenderer(r);
        Icon icon = UIManager.getIcon("CheckBox.icon");
        this.checkBoxWidth = SyntheticaLookAndFeel.getInsets((String)"JYCheckBoxTree.cell.insets", (Component)this, (boolean)false, (boolean)true).left + (icon == null ? 0 : icon.getIconWidth());
        this.setToggleClickCount(-1);
        MouseAdapter ma = new MouseAdapter(){
            private boolean dragEnabled;
            private TreePath startPath;

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() != 1) {
                    return;
                }
                JYCheckBoxTree.this.mousePressed = true;
                TreePath path = JYCheckBoxTree.this.getPathForLocation(evt.getX(), evt.getY());
                if (path != null) {
                    this.startPath = path;
                    JYCheckBoxTree.this.clickedNode = path.getLastPathComponent();
                    Rectangle pathBounds = JYCheckBoxTree.this.getPathBounds(path);
                    if (pathBounds != null) {
                        pathBounds.width = JYCheckBoxTree.this.checkBoxWidth;
                        JYCheckBoxTree.this.checkBoxClicked = pathBounds.contains(evt.getPoint());
                    }
                    if (JYCheckBoxTree.this.checkBoxClicked && JYCheckBoxTree.this.getDragEnabled()) {
                        this.dragEnabled = true;
                        JYCheckBoxTree.this.setDragEnabled(false);
                    }
                    ((JComponent)evt.getComponent()).repaint(pathBounds);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean dragged;
                if (evt.getButton() != 1) {
                    return;
                }
                TreePath path = JYCheckBoxTree.this.getPathForLocation(evt.getX(), evt.getY());
                Rectangle pathBounds = JYCheckBoxTree.this.getPathBounds(path);
                if (pathBounds != null && !JYCheckBoxTree.this.isCheckBoxSelectableByNodeClick()) {
                    pathBounds.width = JYCheckBoxTree.this.checkBoxWidth;
                }
                boolean bl = dragged = path == null || !path.equals(this.startPath);
                if (path != null && pathBounds.contains(evt.getPoint()) && JYCheckBoxTree.this.clickedNode != null && !dragged) {
                    JYCheckBoxTree.this.doSelection(path);
                }
                if (this.dragEnabled) {
                    JYCheckBoxTree.this.setDragEnabled(this.dragEnabled);
                    this.dragEnabled = false;
                }
                this.startPath = null;
                JYCheckBoxTree.this.mousePressed = false;
                JYCheckBoxTree.this.clickedNode = null;
                evt.getComponent().repaint();
            }
        };
        this.addMouseListener(ma);
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "selectCheckBox");
        this.getActionMap().put("selectCheckBox", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] paths = JYCheckBoxTree.this.getSelectionPaths();
                if (paths != null) {
                    TreePath[] treePathArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath path = treePathArray[n2];
                        JYCheckBoxTree.this.doSelection(path);
                        ++n2;
                    }
                }
            }
        });
    }

    void doSelection(TreePath path) {
        if (this.isEnabled()) {
            this.selectCheckBoxPath(path, !this.checkBoxSelectionModel.isPathSelected(path));
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.clearCheckBoxSelection();
        super.setModel(newModel);
    }

    public void clearCheckBoxSelection() {
        CheckBoxSelectionModel checkBoxModel = this.getCheckBoxSelectionModel();
        if (checkBoxModel != null) {
            checkBoxModel.clearSelection();
        }
    }

    protected void selectCheckBoxPath(TreePath path, boolean select) {
        if (select) {
            this.checkBoxSelectionModel.addSelectionPath(path);
        } else {
            this.checkBoxSelectionModel.removeSelectionPath(path);
        }
    }

    public void setCheckBoxSelectableByNodeClick(boolean b) {
        this.checkBoxSelectableByNodeClick = b;
    }

    public boolean isCheckBoxSelectableByNodeClick() {
        return this.checkBoxSelectableByNodeClick;
    }

    public CheckBoxSelectionModel getCheckBoxSelectionModel() {
        return this.checkBoxSelectionModel;
    }

    public void setCheckBoxSelectionModel(CheckBoxSelectionModel model) {
        this.checkBoxSelectionModel = model;
        this.checkBoxSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JYCheckBoxTree.this.treeDidChange();
            }
        });
    }

    @Override
    public void updateUI() {
        boolean cleanUp = this.ui != null;
        super.updateUI();
        if (cleanUp) {
            ((BasicTreeUI)this.getUI()).uninstallUI(this);
            ((BasicTreeUI)this.getUI()).installUI(this);
        }
    }

    private static Rectangle getDropTreeRect(JTree tree) {
        Rectangle rect = tree.getBounds();
        JScrollPane scroller = (JScrollPane)(tree.getParent() != null ? tree.getParent().getParent() : null);
        if (scroller != null) {
            Insets ins = scroller.getInsets();
            rect.y += ins.top;
            rect.height -= ins.top + ins.bottom;
        }
        return rect;
    }

    public class CheckBoxRenderer
    extends JYCheckBox
    implements TreeCellRenderer,
    UIResource {
        private static final long serialVersionUID = 6353437826308600712L;
        private TreeCellRenderer defaultRenderer;

        public CheckBoxRenderer(TreeCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
            this.setName("JYCheckBoxTree.cellRenderer");
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.defaultRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)this.defaultRenderer;
                DefaultTreeCellRenderer r_ = new DefaultTreeCellRenderer();
                r.setTextNonSelectionColor(r_.getTextNonSelectionColor());
                r.setTextSelectionColor(r_.getTextSelectionColor());
                r.setBackgroundNonSelectionColor(r_.getBackgroundNonSelectionColor());
                r.setBackgroundSelectionColor(r_.getBackgroundSelectionColor());
                r.setFont(r_.getFont());
            }
        }

        public Icon getDefaultTreeLeafIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultLeafIcon() : null;
        }

        public Icon getDefaultTreeOpenIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultOpenIcon() : null;
        }

        public Icon getDefaultTreeClosedIcon() {
            return this.defaultRenderer instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)this.defaultRenderer).getDefaultClosedIcon() : null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                if (JYCheckBoxTree.this.checkBoxSelectionModel.isPathSelected(path)) {
                    this.setState(JYCheckBox.State.SELECTED);
                } else {
                    this.setState(JYCheckBoxTree.this.checkBoxSelectionModel.isPartiallySelected(path) ? JYCheckBox.State.HALF_SELECTED : JYCheckBox.State.DESELECTED);
                }
                if (JYCheckBoxTree.this.checkBoxClicked) {
                    boolean pressed = JYCheckBoxTree.this.clickedNode == value && JYCheckBoxTree.this.mousePressed;
                    this.getModel().setArmed(pressed);
                    this.getModel().setPressed(pressed);
                }
            }
            this.setText(r.getText());
            this.setFont(r.getFont());
            JTree.DropLocation dropLocation = tree.getDropLocation();
            if (dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row && JYCheckBoxTree.getDropTreeRect(tree).contains(dropLocation.getDropPoint())) {
                selected = true;
            }
            this.setForeground(selected ? r.getTextSelectionColor() : r.getTextNonSelectionColor());
            this.setBackground(selected ? r.getBackgroundSelectionColor() : r.getBackgroundNonSelectionColor());
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYCheckBoxTree.cell.insets", (Component)tree);
            this.setBorder(insets == null ? r.getBorder() : SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static class CheckBoxSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1526281621712666620L;
        protected JTree tree;

        public CheckBoxSelectionModel(JTree tree) {
            this.tree = tree;
            this.setSelectionMode(4);
        }

        public boolean isPartiallySelected(TreePath path) {
            Object node = path.getLastPathComponent();
            TreeModel m = this.tree.getModel();
            if (m == null) {
                return false;
            }
            int childs = m.getChildCount(node);
            int i = 0;
            while (i < childs) {
                Object childNode = m.getChild(node, i);
                TreePath p = path.pathByAddingChild(childNode);
                if (this.isPathSelected(p) || this.isPartiallySelected(p)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            this.addSuperSelectionPaths(paths);
            HashSet<TreePath> processedParents = new HashSet<TreePath>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath == null) {
                    this.selectPath(path, true);
                } else if (!processedParents.contains(parentPath)) {
                    this.selectPath(path, true);
                    processedParents.add(parentPath);
                }
                ++n2;
            }
        }

        protected void addSuperSelectionPaths(TreePath[] paths) {
            super.addSelectionPaths(paths);
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
            this.removeSuperSelectionPaths(paths);
            HashSet<TreePath> processedParents = new HashSet<TreePath>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                if (parentPath == null) {
                    this.selectPath(path, false);
                } else if (!processedParents.contains(parentPath)) {
                    this.selectPath(path, false);
                    processedParents.add(parentPath);
                }
                ++n2;
            }
        }

        protected void removeSuperSelectionPaths(TreePath[] paths) {
            super.removeSelectionPaths(paths);
        }

        protected void selectPath(TreePath path, boolean select) {
            TreeModel m = this.tree.getModel();
            if (m == null) {
                return;
            }
            this.selectPath_(path, select);
            TreePath parentPath = path.getParentPath();
            while (parentPath != null) {
                this.addSuperSelectionPaths(new TreePath[]{parentPath});
                Object parentNode = parentPath.getLastPathComponent();
                int childs = m.getChildCount(parentNode);
                int i = 0;
                while (i < childs) {
                    Object childNode = m.getChild(parentNode, i);
                    TreePath p = parentPath.pathByAddingChild(childNode);
                    if (!this.isPathSelected(p)) {
                        this.removeSuperSelectionPaths(new TreePath[]{parentPath});
                        break;
                    }
                    ++i;
                }
                parentPath = parentPath.getParentPath();
            }
        }

        private void selectPath_(TreePath path, boolean select) {
            Object node = path.getLastPathComponent();
            if (select) {
                this.addSuperSelectionPaths(new TreePath[]{path});
            } else {
                this.removeSuperSelectionPaths(new TreePath[]{path});
            }
            TreeModel model = this.tree.getModel();
            int childs = model.getChildCount(node);
            TreePath[] paths = new TreePath[childs];
            int i = 0;
            while (i < childs) {
                Object childNode = model.getChild(node, i);
                TreePath p = path.pathByAddingChild(childNode);
                if (model.getChildCount(childNode) > 0) {
                    this.selectPath_(p, select);
                } else {
                    paths[i] = p;
                }
                ++i;
            }
            if (select) {
                this.addSuperSelectionPaths(paths);
            } else {
                this.removeSuperSelectionPaths(paths);
            }
        }
    }

    public static class CheckBoxTreeRenderer
    implements TreeCellRenderer {
        private CheckBoxRenderer checkBoxRenderer;
        private Icon openIcon;
        private Icon closedIcon;
        private Icon leafIcon;
        private int cacheHash;
        private JPanel panel;
        private JLabel label;

        public CheckBoxTreeRenderer(CheckBoxRenderer checkBoxRenderer) {
            this.checkBoxRenderer = checkBoxRenderer;
            this.label = new JRendererLabel();
            this.label.setOpaque(!SyntheticaLookAndFeel.getBoolean((String)"Synthetica.cellRenderer.selectionBackground.enabled", null));
            this.panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = this.getInsets().left + this.getInsets().right;
                    Component[] componentArray = panel.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        d.width += c.getPreferredSize().width;
                        ++n2;
                    }
                    return d;
                }
            };
            this.panel.setOpaque(false);
            this.panel.add(this.label);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JTree.DropLocation dropLocation = tree.getDropLocation();
            if (dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row && JYCheckBoxTree.getDropTreeRect(tree).contains(dropLocation.getDropPoint())) {
                selected = true;
            }
            JYCheckBox cb = (JYCheckBox)this.checkBoxRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            cb.setText("");
            int hash = this.calcCacheHash(cb, value, selected, expanded, leaf, row, hasFocus);
            if (hash == this.cacheHash) {
                this.label.setText(value.toString());
                return this.panel;
            }
            this.cacheHash = hash;
            this.panel.add((Component)cb, "West");
            this.label.setText(value.toString());
            if (leaf) {
                this.label.setIcon(this.leafIcon == null ? this.checkBoxRenderer.getDefaultTreeLeafIcon() : this.leafIcon);
            } else {
                this.label.setIcon(expanded ? (this.openIcon == null ? this.checkBoxRenderer.getDefaultTreeOpenIcon() : this.openIcon) : (this.closedIcon == null ? this.checkBoxRenderer.getDefaultTreeClosedIcon() : this.closedIcon));
            }
            this.label.setForeground(cb.getForeground());
            this.label.setBackground(cb.getBackground());
            return this.panel;
        }

        private int calcCacheHash(JYCheckBox cb, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int hash = row;
            hash = 31 * hash + (cb.getModel().isPressed() ? 0 : 1);
            hash = 31 * hash + (selected ? 0 : 1);
            hash = 31 * hash + (expanded ? 0 : 1);
            hash = 31 * hash + (leaf ? 0 : 1);
            hash = 31 * hash + (hasFocus ? 0 : 1);
            return hash;
        }

        public void setOpenIcon(Icon openIcon) {
            this.openIcon = openIcon;
        }

        public Icon getOpenIcon() {
            return this.openIcon;
        }

        public void setClosedIcon(Icon closedIcon) {
            this.closedIcon = closedIcon;
        }

        public Icon getClosedIcon() {
            return this.closedIcon;
        }

        public void setLeafIcon(Icon leafIcon) {
            this.leafIcon = leafIcon;
        }

        public Icon getLeafIcon() {
            return this.leafIcon;
        }
    }
}

