/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SizeRequirements;

public class OverlapBoxLayout<T extends Component>
implements LayoutManager2 {
    private Container container;
    private Axis axis;
    private Class<T> childClass;
    private ComponentFilter filter;
    private int overlapSize;
    private boolean spaceForInvisibleComponentsRetained;
    private ArrayList<T> components;
    private int hAlign;
    private int vAlign;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;

    public OverlapBoxLayout(Container container, Axis axis, Class<T> childClass) {
        this(container, axis, childClass, new ComponentFilter());
    }

    public OverlapBoxLayout(Container container, Axis axis, Class<T> childClass, ComponentFilter filter) {
        this.container = container;
        this.childClass = childClass;
        this.axis = axis;
        this.filter = filter;
        this.components = new ArrayList();
        this.hAlign = 2;
        this.vAlign = 1;
    }

    public final Container getContainer() {
        return this.container;
    }

    public List<T> getComponents() {
        return this.components;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public void setOverlapSize(int size) {
        this.overlapSize = size;
    }

    public int getOverlapSize() {
        return this.overlapSize;
    }

    public void setSpaceForInvisibleComponentsRetained(boolean b) {
        this.spaceForInvisibleComponentsRetained = b;
    }

    public boolean isSpaceForInvisibleComponentsRetained() {
        return this.spaceForInvisibleComponentsRetained;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
        if (this.filter.accept(c, this.childClass, null)) {
            this.components.add(c);
        }
        this.invalidateLayout(c.getParent());
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.components.remove(c);
        this.invalidateLayout(c.getParent());
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (this.filter.accept(c, this.childClass, constraints)) {
            if (constraints instanceof Integer) {
                this.components.add((Integer)constraints, c);
            } else {
                this.components.add(c);
            }
        }
        this.invalidateLayout(c.getParent());
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension prefSize = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        prefSize.width = (int)Math.min((long)prefSize.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        prefSize.height = (int)Math.min((long)prefSize.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return prefSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension minSize = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        minSize.width = (int)Math.min((long)minSize.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        minSize.height = (int)Math.min((long)minSize.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return minSize;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension maxSize = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        maxSize.width = (int)Math.min((long)maxSize.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        maxSize.height = (int)Math.min((long)maxSize.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return maxSize;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    @Override
    public void layoutContainer(Container container) {
        int yAlignOffset;
        int xAlignOffset;
        this.checkContainer(container);
        this.checkRequests();
        int n = this.components.size();
        int[] xOffsets = new int[n];
        int[] xSpans = new int[n];
        int[] yOffsets = new int[n];
        int[] ySpans = new int[n];
        Dimension size = container.getSize();
        Insets insets = container.getInsets();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        ComponentOrientation o = container.getComponentOrientation();
        Axis absoluteAxis = this.resolveAxis(this.axis, o.isHorizontal());
        boolean xAxis = absoluteAxis == Axis.X;
        boolean ltr = !xAxis || xAxis && o.isLeftToRight();
        boolean bl = ltr = absoluteAxis != this.axis ? ltr : true;
        if (xAxis) {
            SizeRequirements.calculateTiledPositions(size.width, this.xTotal, this.xChildren, xOffsets, xSpans, ltr);
            SizeRequirements.calculateAlignedPositions(size.height, this.yTotal, this.yChildren, yOffsets, ySpans);
        } else {
            SizeRequirements.calculateAlignedPositions(size.width, this.xTotal, this.xChildren, xOffsets, xSpans, ltr);
            SizeRequirements.calculateTiledPositions(size.height, this.yTotal, this.yChildren, yOffsets, ySpans);
        }
        int n2 = !xAxis || this.hAlign == 2 ? 0 : (xAlignOffset = (size.width - this.xTotal.preferred) / (this.hAlign == 0 ? 2 : 1));
        int n3 = xAxis || this.vAlign == 1 ? 0 : (yAlignOffset = (size.height - this.yTotal.preferred) / (this.vAlign == 0 ? 2 : 1));
        if (!ltr) {
            xAlignOffset *= -1;
        }
        int i = 0;
        while (i < n) {
            Component c = (Component)this.components.get(i);
            int overlap = this.getOverlap(n, i, ltr);
            int ow = xAxis ? overlap : 0;
            int oh = xAxis ? 0 : overlap;
            this.setComponentBounds(c, (int)Math.min((long)insets.left + (long)xOffsets[i] + (long)ow + (long)xAlignOffset, Integer.MAX_VALUE), (int)Math.min((long)insets.top + (long)yOffsets[i] + (long)oh + (long)yAlignOffset, Integer.MAX_VALUE), xSpans[i] - ow, ySpans[i] - oh);
            ++i;
        }
        Component[] componentArray = container.getComponents();
        int n4 = componentArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Component c = componentArray[n5];
            if (!this.components.contains(c)) {
                c.setBounds(new Rectangle());
            }
            ++n5;
        }
    }

    protected void setComponentBounds(T c, int x, int y, int w, int h) {
        ((Component)c).setBounds(x, y, w, h);
    }

    void checkContainer(Container container) {
        if (this.container != container) {
            throw new AWTError("OverlapBoxLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            ComponentOrientation o = this.container.getComponentOrientation();
            Axis absoluteAxis = this.resolveAxis(this.axis, o.isHorizontal());
            boolean xAxis = absoluteAxis == Axis.X;
            boolean ltr = !xAxis || xAxis && o.isLeftToRight();
            ltr = absoluteAxis != this.axis ? ltr : true;
            int n = this.components.size();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            int i = 0;
            while (i < n) {
                Component c = (Component)this.components.get(i);
                if (!c.isVisible() && !this.spaceForInvisibleComponentsRetained) {
                    this.xChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentX());
                    this.yChildren[i] = new SizeRequirements(0, 0, 0, c.getAlignmentY());
                } else {
                    Dimension min = c.getMinimumSize();
                    Dimension pref = c.getPreferredSize();
                    Dimension max = c.getMaximumSize();
                    int overlap = this.getOverlap(n, i, ltr);
                    int ow = xAxis ? overlap : 0;
                    int oh = xAxis ? 0 : overlap;
                    this.xChildren[i] = new SizeRequirements(min.width + ow, pref.width + ow, max.width + ow, c.getAlignmentX());
                    this.yChildren[i] = new SizeRequirements(min.height + oh, pref.height + oh, max.height + oh, c.getAlignmentY());
                }
                ++i;
            }
            if (xAxis) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private int getOverlap(int n, int i, boolean ltr) {
        if (ltr) {
            int firstVisible = 0;
            if (!this.isSpaceForInvisibleComponentsRetained()) {
                int j = 0;
                while (j < n) {
                    Component c = (Component)this.components.get(j);
                    if (c.isVisible()) {
                        firstVisible = j;
                        break;
                    }
                    ++j;
                }
            }
            return i > firstVisible ? this.overlapSize : 0;
        }
        return i < n - 1 ? this.overlapSize : 0;
    }

    private Axis resolveAxis(Axis axis, boolean horizontal) {
        Axis absoluteAxis = axis == Axis.LINE ? (horizontal ? Axis.X : Axis.Y) : (axis == Axis.PAGE ? (horizontal ? Axis.Y : Axis.X) : axis);
        return absoluteAxis;
    }

    public void setHorizontalAlignment(int alignment) {
        this.hAlign = alignment;
    }

    public int getHorizontalAlignment() {
        return this.hAlign;
    }

    public void setVerticalAlignment(int alignment) {
        this.vAlign = alignment;
    }

    public int getVerticalAlignment() {
        return this.vAlign;
    }

    public static enum Axis {
        X,
        Y,
        PAGE,
        LINE;

    }

    public static class ComponentFilter {
        public boolean accept(Component c, Class<?> childClass, Object constraints) {
            return childClass.isInstance(c);
        }
    }
}

