/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.xmenu.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.util.WidgetUtils;
import de.javasoft.xmenu.XMenu;
import de.javasoft.xmenu.XMenuBar;
import de.javasoft.xmenu.ui.XMenuUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicXMenuUI
extends XMenuUI
implements PropertyChangeListener {
    protected XMenu xMenu;
    protected AbstractButton menuButton;
    private MouseAdapter mouseHandler;
    private static MenuElement[] menuPath;
    private static ChangeListener menuChangeListener;

    static {
        final MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        FocusManager.getCurrentManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("focusedWindow".equals(evt.getPropertyName())) {
                    manager.clearSelectedPath();
                }
            }
        });
        menuChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MenuElement element;
                if (manager.getSelectedPath().length == 0 && menuPath != null) {
                    manager.setSelectedPath(menuPath);
                } else if (manager.getSelectedPath().length == 1 && menuPath != null && (element = manager.getSelectedPath()[0]) instanceof Component && SwingUtilities.getAncestorOfClass(XMenuBar.class, (Component)((Object)element)) != null) {
                    MenuElement[] newPath = new MenuElement[menuPath.length + 1];
                    int i = 0;
                    while (i < menuPath.length) {
                        newPath[i] = menuPath[i];
                        ++i;
                    }
                    newPath[newPath.length - 1] = element;
                    manager.setSelectedPath(newPath);
                }
            }
        };
        manager.addChangeListener(menuChangeListener);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicXMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.xMenu = (XMenu)c;
        if (!(this.xMenu.getMenuLayout() instanceof BorderLayout)) {
            this.xMenu.setMenuLayout(new BorderLayout());
        }
        super.installUI(c);
        this.installDefaults(c);
        this.installListeners(c);
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults(c);
        this.uninstallListeners(c);
        this.uninstallKeyboardActions();
    }

    protected void installDefaults(JComponent c) {
        this.xMenu.getActionMap().put("selectMenu", new SelectMenuAction());
        this.xMenu.setBorderPainted(true);
        if (this.xMenu.getBorder() == null || this.xMenu.getBorder() instanceof UIResource) {
            this.xMenu.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"XMenu.insets", (Component)this.xMenu, (boolean)false, (boolean)true), true));
        }
        if (this.xMenu.getMenuButton() == null) {
            this.menuButton = this.createMenuButton();
            this.xMenu.setMenuButton(this.menuButton);
        } else {
            this.menuButton = this.xMenu.getMenuButton();
            this.menuButton.updateUI();
        }
        this.xMenu.addPropertyChangeListener(this);
        if (this.xMenu.animationEnabledIsUIResource()) {
            this.xMenu.setAnimationEnabled(SyntheticaLookAndFeel.getBoolean((String)"XMenu.animation.enabled", (Component)this.xMenu, (boolean)true), true);
        }
    }

    protected void uninstallDefaults(JComponent c) {
        this.xMenu.removePropertyChangeListener(this);
    }

    protected void installListeners(JComponent c) {
        c.addMouseListener(this.getMouseHandler());
    }

    protected void uninstallListeners(JComponent c) {
        c.removeMouseListener(this.getMouseHandler());
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public static void dispose() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        manager.removeChangeListener(menuChangeListener);
        manager.clearSelectedPath();
        menuPath = null;
    }

    private MouseAdapter getMouseHandler() {
        if (this.mouseHandler == null) {
            this.mouseHandler = this.createMouseHandler();
        }
        return this.mouseHandler;
    }

    protected MouseAdapter createMouseHandler() {
        this.mouseHandler = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.xMenu.getModel().setRollover(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.xMenu.getModel().setRollover(false);
                }
                BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                BasicXMenuUI.this.xMenu.getModel().setPressed(false);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.selectMenu(evt);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                BasicXMenuUI.this.xMenu.getModel().setArmed(true);
                BasicXMenuUI.this.xMenu.getModel().setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                BasicXMenuUI.this.xMenu.getModel().setPressed(false);
            }
        };
        return this.mouseHandler;
    }

    protected AbstractButton createMenuButton() {
        JButton button = new JButton(this.xMenu.getText()){

            @Override
            protected void paintComponent(Graphics g) {
                BasicXMenuUI.this.paintButtonBackground(BasicXMenuUI.this.xMenu, BasicXMenuUI.this.xMenu.isSelected(), g, 0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }

            @Override
            public boolean hasFocus() {
                return false;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(BasicXMenuUI.this.xMenu.getForeground());
                this.setFont(BasicXMenuUI.this.xMenu.getFont());
                this.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"XMenu.menuButton.insets", (Component)BasicXMenuUI.this.xMenu, (Insets)new Insets(4, 4, 4, 4), (boolean)true), true));
            }
        };
        button.setName("XMenu.menuButton");
        button.setModel(new DefaultButtonModel(){

            @Override
            public boolean isPressed() {
                return BasicXMenuUI.this.xMenu.getModel().isPressed();
            }

            @Override
            public boolean isArmed() {
                return BasicXMenuUI.this.xMenu.getModel().isArmed();
            }

            @Override
            public boolean isSelected() {
                return BasicXMenuUI.this.xMenu.getModel().isSelected();
            }
        });
        button.setFocusable(false);
        button.setMnemonic(this.xMenu.getMnemonic());
        button.putClientProperty("Synthetica.opaque", false);
        MouseAdapter redispatcher = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    this.dispatchMouseEvent(evt);
                } else {
                    BasicXMenuUI.this.selectMenu(evt);
                    BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                    BasicXMenuUI.this.xMenu.getModel().setPressed(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            private void dispatchMouseEvent(MouseEvent evt) {
                Container parent = evt.getComponent().getParent();
                parent.dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, parent));
                BasicXMenuUI.this.xMenu.repaint();
            }
        };
        button.addMouseListener(redispatcher);
        button.addMouseMotionListener(redispatcher);
        return button;
    }

    protected boolean isMouseSensitive() {
        return SyntheticaLookAndFeel.getBoolean((String)"XMenu.mouseSensitive", (Component)this.xMenu, (boolean)false);
    }

    private void selectMenu(MouseEvent evt) {
        AbstractButton b = (AbstractButton)evt.getSource();
        if (b.isEnabled() && evt.getButton() == 1) {
            this.xMenu.getActionMap().get("selectMenu").actionPerformed(new ActionEvent(this.xMenu, 1001, ""));
        }
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        this.paintBackground(c, g, 0, 0, c.getWidth(), c.getHeight());
        super.paint(g, c);
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
    }

    protected void paintContentPaneBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
    }

    protected void paintButtonBackground(JComponent c, boolean selected, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.installDefaults(c);
        }
        if ("mnemonic".equals(name)) {
            SwingXUtilities.updateMnemonicBinding((JComponent)this.xMenu, (String)"selectMenu");
            this.menuButton.setMnemonic((Integer)evt.getNewValue());
        } else if ("text".equals(name)) {
            this.menuButton.setText("" + evt.getNewValue());
        } else if ("foreground".equals(name)) {
            this.menuButton.setForeground((Color)evt.getNewValue());
        } else if ("font".equals(name)) {
            Font f = (Font)evt.getNewValue();
            this.menuButton.setFont(f == null ? null : f.deriveFont(f.getStyle()));
        } else if ("icon".equals(name)) {
            this.menuButton.setIcon((Icon)evt.getNewValue());
        } else if ("enabled".equals(name)) {
            this.menuButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    public Border createContentPaneBorder() {
        return new ContentPaneBorder();
    }

    private class ContentPaneBorder
    implements Border {
        private Insets insets;

        private ContentPaneBorder() {
            this.insets = SyntheticaLookAndFeel.getInsets((String)"XMenu.contentPane.insets", (Component)BasicXMenuUI.this.xMenu, (Insets)new Insets(0, 0, 0, 0), (boolean)true);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicXMenuUI.this.paintContentPaneBackground(BasicXMenuUI.this.xMenu, g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Insets ins = new Insets(this.insets.top, 0, this.insets.bottom, 0);
            ins.left = ltr ? this.insets.left : this.insets.right;
            ins.right = ltr ? this.insets.right : this.insets.left;
            return ins;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class SelectMenuAction
    extends AbstractAction {
        public SelectMenuAction() {
            super("selectMenu");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Container parent = BasicXMenuUI.this.xMenu.getParent();
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof XMenu && c != BasicXMenuUI.this.xMenu && !((XMenu)c).isCollapsed()) {
                    ((XMenu)c).setCollapsed(true);
                }
                ++n2;
            }
            BasicXMenuUI.this.xMenu.setCollapsed(!BasicXMenuUI.this.xMenu.isCollapsed());
            this.setSelectedPath();
        }

        private void setSelectedPath() {
            Container parent;
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (!BasicXMenuUI.this.xMenu.isSelected() && (parent = BasicXMenuUI.this.xMenu.getParent()) != null && parent instanceof JMenuBar) {
                MenuElement[] me = new MenuElement[]{(MenuElement)((Object)parent), BasicXMenuUI.this.xMenu};
                menuPath = me;
                manager.setSelectedPath(menuPath);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicXMenuUI.this.xMenu.isEnabled();
        }
    }
}

