/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ScalableImage
extends BaseMultiResolutionImage
implements Scalable {
    public ScalableImage(Class<?> resourceBase, String ... fileNames) {
        super(ScalableImage.getImageArray(resourceBase, fileNames));
    }

    private static Image[] getImageArray(Class<?> resourceBase, String ... fileNames) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                URL url = resourceBase.getResource(name);
                if (url == null) {
                    throw new RuntimeException("File not found: " + name);
                }
                images.add(ImageIO.read(url));
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return images.toArray(new Image[images.size()]);
    }

    public ScalableImage(Image ... images) {
        super(images);
    }

    protected float getScaleFactor() {
        SyntheticaLookAndFeel instance = SyntheticaLookAndFeel.getInstance();
        return instance == null ? (float)SyntheticaLookAndFeel.getInt("Synthetica.scaleFactor", null, 100, false) / 100.0f : instance.getScaleFactor();
    }

    public int getScaledWidth() {
        return (int)((float)this.getWidth(null) * this.getScaleFactor());
    }

    public int getScaledHeight() {
        return (int)((float)this.getHeight(null) * this.getScaleFactor());
    }

    public Image getScaledInstance() {
        int w = this.getScaledWidth();
        int h = this.getScaledHeight();
        Image image = this.getResolutionVariant(w, h);
        return HiDpi.scaleImage(image, w, h);
    }
}

