/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class SyntheticaMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthConstants {
    private static boolean paintDebugRects = UIManager.getBoolean("Synthetica.menuItem.paintDebugRectangles");
    private static WeakHashMap<JPopupMenu, MaxWidth> maxWidths = new WeakHashMap();
    private String acceleratorDelimiter;
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle acceleratorRect = new Rectangle();
    private static Rectangle checkIconRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        String prefix = this.getPropertyPrefix();
        SynthContext sc = SyntheticaMenuItemUI.getContext((JComponent)mi, 1);
        SynthStyle style = SyntheticaMenuItemUI.getStyle(mi);
        style.installDefaults(sc);
        Integer value = style.getInt(sc, "MenuItem.textIconGap", 4);
        if (value != null) {
            LookAndFeel.installProperty(mi, "iconTextGap", value);
        }
        this.defaultTextIconGap = mi.getIconTextGap();
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            Insets insets = (Insets)style.get(sc, String.valueOf(prefix) + ".margin");
            if (insets == null) {
                insets = new InsetsUIResource(0, 0, 0, 0);
            }
            this.menuItem.setMargin(insets);
        }
        this.acceleratorDelimiter = style.getString(sc, String.valueOf(prefix) + ".acceleratorDelimiter", SyntheticaMenuItemUI.getAcceleratorDelimiter());
        this.arrowIcon = style.getIcon(sc, String.valueOf(prefix) + ".arrowIcon");
        this.arrowIcon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.arrowIcon", this.menuItem, this.arrowIcon);
        this.checkIcon = style.getIcon(sc, String.valueOf(prefix) + ".checkIcon");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SynthContext sc = SyntheticaMenuItemUI.getMenuItemContext(c);
        SynthContext accContext = SyntheticaMenuItemUI.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SyntheticaMenuItemUI.getPreferredMenuItemSize(sc, accContext, false, c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter);
        return value;
    }

    static Dimension getPreferredMenuItemSize(SynthContext sc, SynthContext accContext, boolean isTopLevelMenu, JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, String acceleratorDelimiter) {
        JMenuItem mi = (JMenuItem)c;
        Icon icon = mi.getIcon();
        String text = mi.getText();
        KeyStroke accelerator = mi.getAccelerator();
        String acceleratorText = "";
        JPopupMenu popup = SyntheticaMenuItemUI.findPopup(mi);
        int menuItemGap = sc.getStyle().getInt(sc, "MenuItem.textIconGap", defaultTextIconGap);
        int textIconGap = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.textIconGap", popup, menuItemGap, true, false);
        int acceleratorGap = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.acceleratorGap", popup, menuItemGap * 4, true, false);
        int separatorGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", popup, 0, true);
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = SyntheticaMenuItemUI.modifiersAsText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        Font font = sc.getStyle().getFont(sc);
        FontMetrics fm = mi.getFontMetrics(font);
        FontMetrics fmAccel = mi.getFontMetrics(accContext.getStyle().getFont(accContext));
        SyntheticaMenuItemUI.resetRects();
        SyntheticaMenuItemUI.layoutMenuItem(sc, fm, accContext, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, mi.getVerticalAlignment(), mi.getHorizontalAlignment(), mi.getVerticalTextPosition(), mi.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap, isTopLevelMenu);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(isTopLevelMenu ? SyntheticaMenuItemUI.iconRect.x : SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.iconRect.y, isTopLevelMenu ? SyntheticaMenuItemUI.iconRect.width : 0, SyntheticaMenuItemUI.iconRect.height, r);
        if (popup != null) {
            MaxWidth mw = maxWidths.get(popup);
            if (mw == null) {
                maxWidths.put(popup, new MaxWidth());
                mw = maxWidths.get(popup);
            } else if (SyntheticaMenuItemUI.isHorizontalLayout(popup)) {
                mw.clear();
            }
            SyntheticaMenuItemUI.r.width = mw.maxTextWidth = Math.max(mw.maxTextWidth, SyntheticaMenuItemUI.r.width);
            mw.maxAcceleratorWidth = Math.max(mw.maxAcceleratorWidth, SyntheticaMenuItemUI.acceleratorRect.width);
            SyntheticaMenuItemUI.r.width += mw.maxAcceleratorWidth;
            if (mw.maxAcceleratorWidth > 0) {
                SyntheticaMenuItemUI.r.width += acceleratorGap;
            }
            SyntheticaMenuItemUI.r.width += mw.maxIconWidth;
            if (mw.maxIconWidth > 0) {
                SyntheticaMenuItemUI.r.width += textIconGap;
            }
            if (!isTopLevelMenu) {
                if (SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup)) {
                    SyntheticaMenuItemUI.r.width += mw.maxCheckIconWidth;
                    if (mw.maxCheckIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width += menuItemGap;
                    }
                } else if (SyntheticaLookAndFeel.popupHasCheckRadio(popup)) {
                    SyntheticaMenuItemUI.r.width -= mw.maxIconWidth;
                    SyntheticaMenuItemUI.r.width += Math.max(mw.maxIconWidth, mw.maxCheckIconWidth);
                    if (mw.maxIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width -= textIconGap;
                    }
                    SyntheticaMenuItemUI.r.width += menuItemGap;
                }
                if (mw.maxAcceleratorWidth == 0) {
                    SyntheticaMenuItemUI.r.width += mw.maxArrowIconWidth;
                    if (mw.maxArrowIconWidth > 0) {
                        SyntheticaMenuItemUI.r.width += menuItemGap;
                    }
                }
            }
        } else if (!isTopLevelMenu) {
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.acceleratorRect.width;
            if (SyntheticaMenuItemUI.acceleratorRect.width > 0) {
                SyntheticaMenuItemUI.r.width += acceleratorGap;
            }
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.iconRect.width;
            if (SyntheticaMenuItemUI.iconRect.width > 0) {
                SyntheticaMenuItemUI.r.width += textIconGap;
            }
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.checkIconRect.width;
            if (SyntheticaMenuItemUI.checkIconRect.width > 0) {
                SyntheticaMenuItemUI.r.width += menuItemGap;
            }
            int arrowIconGap = arrowIcon == null ? 0 : SyntheticaLookAndFeel.getInt("Synthetica.menuItem.arrowIconGap", c, menuItemGap, true, false);
            SyntheticaMenuItemUI.r.width += SyntheticaMenuItemUI.arrowIconRect.width + arrowIconGap;
        }
        SyntheticaMenuItemUI.r.width = SyntheticaMenuItemUI.r.width + (isTopLevelMenu ? menuItemGap : menuItemGap * 2);
        if (!isTopLevelMenu && popup != null && (SyntheticaLookAndFeel.preservePopupIconSpace(popup) || SyntheticaLookAndFeel.popupHasCheckRadio(popup))) {
            SyntheticaMenuItemUI.r.width += separatorGap;
        }
        Insets insets = sc.getStyle().getInsets(sc, null);
        Insets margin = mi.getMargin();
        if (margin != null) {
            insets = new Insets(insets.top + margin.top, insets.left + margin.left, insets.bottom + margin.bottom, insets.right + margin.right);
        }
        SyntheticaMenuItemUI.r.width = (SyntheticaMenuItemUI.r.width = SyntheticaMenuItemUI.r.width + ((isTopLevelMenu ? 0 : insets.left) + insets.right)) + (isTopLevelMenu && icon != null ? insets.left + textIconGap : 0);
        SyntheticaMenuItemUI.r.height += insets.top + insets.bottom;
        int xOffset = SyntheticaLookAndFeel.getInt("Menu.menuPopupOffsetX", null, 0, true);
        boolean respectTopLevelMenuWidth = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.respectTopLevelMenuWidth", popup, true);
        if (respectTopLevelMenuWidth && popup != null && SyntheticaLookAndFeel.isToplevelPopupMenu(popup) && SyntheticaMenuItemUI.r.width + xOffset < popup.getInvoker().getWidth()) {
            SyntheticaMenuItemUI.r.width = popup.getInvoker().getWidth() - xOffset;
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuItem.justifySize", popup, true)) {
            if (SyntheticaMenuItemUI.r.width % 2 == 0) {
                ++SyntheticaMenuItemUI.r.width;
            }
            if (SyntheticaMenuItemUI.r.height % 2 == 0) {
                ++SyntheticaMenuItemUI.r.height;
            }
        }
        return r.getSize();
    }

    private static boolean isHorizontalLayout(JPopupMenu popup) {
        if (!(popup.getLayout() instanceof BoxLayout)) {
            return false;
        }
        int axis = ((BoxLayout)popup.getLayout()).getAxis();
        return axis == 0 || axis == 2;
    }

    private static String layoutMenuItem(SynthContext sc, FontMetrics fm, SynthContext accContext, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int defaultTextIconGap, int defaultMenuItemGap, boolean isTopLevelMenu) {
        boolean popupHasCheckRadio;
        boolean popupHasIcons;
        int maxArrowIconWidth;
        JComponent c = sc.getComponent();
        JPopupMenu popup = SyntheticaMenuItemUI.findPopup(c);
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        int menuItemGap = sc.getStyle().getInt(sc, "MenuItem.textIconGap", defaultMenuItemGap);
        int textIconGap = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.textIconGap", popup, menuItemGap, true, false);
        int acceleratorGap = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.acceleratorGap", popup, menuItemGap * 4, true, false);
        int separatorGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", popup, 0, true);
        boolean centerText = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.centerText", popup, false);
        boolean forceIconSpace = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.forceIconSpace", popup, false);
        int maxIconWidth = icon == null ? (forceIconSpace ? SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.defaultIconWidth", popup, 16, true) : 0) : icon.getIconWidth();
        int maxCheckIconWidth = checkIcon == null ? 0 : checkIcon.getIconWidth();
        int n = maxArrowIconWidth = arrowIcon == null ? 0 : arrowIcon.getIconWidth();
        if (popup != null) {
            MaxWidth mw = maxWidths.get(popup);
            if (mw == null) {
                maxWidths.put(popup, new MaxWidth());
                mw = maxWidths.get(popup);
            }
            maxIconWidth = mw.maxIconWidth = Math.max(mw.maxIconWidth, maxIconWidth);
            maxCheckIconWidth = mw.maxCheckIconWidth = Math.max(mw.maxCheckIconWidth, maxCheckIconWidth);
            maxArrowIconWidth = mw.maxArrowIconWidth = Math.max(mw.maxArrowIconWidth, maxArrowIconWidth);
            popup.putClientProperty("Synthetica.menuItem.maxIconWidth", maxIconWidth);
        }
        boolean bl = popup == null ? icon != null : (popupHasIcons = SyntheticaLookAndFeel.preservePopupIconSpace(popup));
        boolean bl2 = popup == null ? checkIcon != null : (popupHasCheckRadio = SyntheticaLookAndFeel.popupHasCheckRadio(popup));
        boolean popupHasCheckRadioWithIcon = popup == null ? popupHasCheckRadio && popupHasIcons : SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup);
        sc.getStyle().getGraphicsUtils(sc).layoutText(sc, fm, text, icon, horizontalAlignment, verticalAlignment, horizontalTextPosition, verticalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (!isTopLevelMenu) {
            if (checkIcon != null) {
                checkIconRect.width = SyntheticaIcon.getIconWidth(checkIcon, sc);
                checkIconRect.height = SyntheticaIcon.getIconHeight(checkIcon, sc);
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = SyntheticaIcon.getIconWidth(arrowIcon, sc);
                arrowIconRect.height = SyntheticaIcon.getIconHeight(arrowIcon, sc);
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        if (isTopLevelMenu) {
            Insets insets = sc.getStyle().getInsets(sc, null);
            textRect.x = ltr ? (textRect.x += menuItemGap + insets.left) : (textRect.x -= menuItemGap + insets.left);
            if (iconRect.width > 0) {
                iconRect.x = iconRect.x + (insets.left + textIconGap) * (ltr ? 1 : -1);
            }
        } else if (popupHasCheckRadioWithIcon) {
            if (ltr) {
                checkIconRect.x = viewRect.x + menuItemGap;
                iconRect.x = viewRect.x + menuItemGap + maxCheckIconWidth + menuItemGap;
                textRect.x = viewRect.x + menuItemGap + maxCheckIconWidth + menuItemGap + maxIconWidth + textIconGap + separatorGap;
            } else {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - maxCheckIconWidth;
                iconRect.x = checkIconRect.x - menuItemGap - maxIconWidth;
                textRect.x = iconRect.x - textIconGap - separatorGap - textRect.width;
            }
        } else if (popupHasIcons && popupHasCheckRadio) {
            int maxLeadingWidth = Math.max(maxCheckIconWidth, maxIconWidth);
            if (ltr) {
                checkIconRect.x = viewRect.x + menuItemGap + (maxLeadingWidth - checkIconRect.width) / 2;
                iconRect.x = viewRect.x + menuItemGap + (maxLeadingWidth - iconRect.width) / 2;
                textRect.x = viewRect.x + menuItemGap + maxLeadingWidth + menuItemGap + separatorGap;
            } else {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - maxCheckIconWidth - (maxLeadingWidth - checkIconRect.width) / 2;
                iconRect.x = viewRect.x + viewRect.width - menuItemGap - maxIconWidth - (maxLeadingWidth - iconRect.width) / 2;
                textRect.x = viewRect.x + viewRect.width - menuItemGap - maxLeadingWidth - menuItemGap - separatorGap - textRect.width;
            }
        } else if (popupHasIcons && !popupHasCheckRadio) {
            if (ltr) {
                iconRect.x = viewRect.x + menuItemGap;
                textRect.x = viewRect.x + menuItemGap + maxIconWidth + textIconGap + (popup == null ? 0 : separatorGap);
            } else {
                iconRect.x = viewRect.x + viewRect.width - menuItemGap - maxIconWidth;
                textRect.x = iconRect.x - textIconGap - (popup == null ? 0 : separatorGap) - textRect.width;
            }
        } else if (!popupHasIcons && popupHasCheckRadio) {
            if (ltr) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x = viewRect.x + menuItemGap + maxCheckIconWidth + menuItemGap + separatorGap;
            } else {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - maxCheckIconWidth;
                textRect.x = checkIconRect.x - menuItemGap - separatorGap - textRect.width;
            }
        } else if (ltr) {
            textRect.x = viewRect.x + menuItemGap;
        } else if (viewRect.width < Short.MAX_VALUE) {
            textRect.x = viewRect.x + viewRect.width - textRect.width - menuItemGap;
            iconRect.x = 0;
        }
        if (!isTopLevelMenu) {
            arrowIconRect.x = ltr ? viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width : viewRect.x + menuItemGap;
        }
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            SynthStyle style = accContext.getStyle();
            acceleratorRect.width = style.getGraphicsUtils(accContext).computeStringWidth(accContext, fmAccel.getFont(), fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        Rectangle labelRect = iconRect.union(textRect);
        int maxAccWidth = maxWidths.get(popup) == null ? acceleratorRect.width : SyntheticaMenuItemUI.maxWidths.get((Object)popup).maxAcceleratorWidth;
        acceleratorRect.x = ltr ? viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - maxAccWidth : viewRect.x + arrowIconRect.width + menuItemGap + maxAccWidth - acceleratorRect.width;
        acceleratorRect.y = labelRect.y + (labelRect.height / 2 - acceleratorRect.height / 2);
        if (!isTopLevelMenu) {
            arrowIconRect.y = labelRect.y + (labelRect.height / 2 - arrowIconRect.height / 2);
            checkIconRect.y = labelRect.y + (labelRect.height / 2 - checkIconRect.height / 2);
        }
        if (!isTopLevelMenu && centerText) {
            int maxWidth = viewRect.width - Math.max(maxAccWidth, maxArrowIconWidth) - menuItemGap * 2;
            if (popupHasCheckRadioWithIcon) {
                maxWidth -= maxIconWidth + menuItemGap + maxCheckIconWidth + textIconGap + separatorGap;
            } else if (popupHasIcons && popupHasCheckRadio) {
                maxWidth -= Math.max(maxIconWidth, maxCheckIconWidth) + menuItemGap + separatorGap;
            } else if (popupHasIcons && !popupHasCheckRadio) {
                maxWidth -= maxIconWidth + textIconGap + separatorGap;
            } else if (!popupHasIcons && popupHasCheckRadio) {
                maxWidth -= maxCheckIconWidth + menuItemGap + separatorGap;
            }
            if (maxAccWidth > 0) {
                maxWidth -= acceleratorGap;
            } else if (maxArrowIconWidth > 0) {
                maxWidth -= menuItemGap;
            }
            textRect.x = textRect.x + (ltr ? (maxWidth - textRect.width) / 2 : -(maxWidth - textRect.width) / 2);
        }
        return text;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext sc = SyntheticaMenuItemUI.getContext(c);
        this.paintBackground(sc, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(sc, g);
        this.paintBorder(sc, g, 0, 0, c.getWidth(), c.getHeight());
    }

    void paintBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuItemBackground(sc, g, x, y, w, h);
    }

    void paintBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuItemBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paint(SyntheticaMenuItemUI.getMenuItemContext(c), g);
    }

    private void paint(SynthContext sc, Graphics g) {
        JComponent c = sc.getComponent();
        SynthStyle ss = SyntheticaMenuItemUI.getStyle(c);
        SynthContext accContext = SyntheticaMenuItemUI.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String prefix = this.getPropertyPrefix();
        Icon arrowIcon = ss.getIcon(sc, String.valueOf(prefix) + ".arrowIcon");
        arrowIcon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.arrowIcon", c, arrowIcon);
        if ((sc.getComponentState() & 2) > 0) {
            arrowIcon = SyntheticaLookAndFeel.getClientProperty("Synthetica.menuItem.hover.arrowIcon", c, arrowIcon);
        }
        SyntheticaMenuItemUI.paint(sc, accContext, g, ss.getIcon(sc, String.valueOf(prefix) + ".checkIcon"), arrowIcon, false, this.acceleratorDelimiter, this.defaultTextIconGap);
    }

    static void paint(SynthContext sc, SynthContext accContext, Graphics g, Icon checkIcon, Icon arrowIcon, boolean isTopLevelMenu, String acceleratorDelimiter, int defaultTextIconGap) {
        FontMetrics fm;
        JComponent c = sc.getComponent();
        JMenuItem mi = (JMenuItem)c;
        SynthStyle style = sc.getStyle();
        ButtonModel model = mi.getModel();
        Insets insets = style.getInsets(sc, null);
        Insets margin = mi.getMargin();
        if (margin != null) {
            insets = new Insets(insets.top + margin.top, insets.left + margin.left, insets.bottom + margin.bottom, insets.right + margin.right);
        }
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        SyntheticaMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, mi.getWidth(), mi.getHeight());
        SyntheticaMenuItemUI.viewRect.y += insets.top;
        SyntheticaMenuItemUI.viewRect.height += -insets.bottom - insets.top;
        if (!isTopLevelMenu) {
            SyntheticaMenuItemUI.viewRect.x = SyntheticaMenuItemUI.viewRect.x + (ltr ? insets.left : insets.right);
            SyntheticaMenuItemUI.viewRect.width += -insets.right - insets.left;
        }
        Font f = style.getFont(sc);
        g.setFont(f);
        FontMetrics accFM = fm = g.getFontMetrics();
        KeyStroke accelerator = mi.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = SyntheticaMenuItemUI.modifiersAsText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        String text = SyntheticaMenuItemUI.layoutMenuItem(sc, fm, accContext, mi.getText(), accFM, acceleratorText, mi.getIcon(), checkIcon, arrowIcon, mi.getVerticalAlignment(), mi.getHorizontalAlignment(), mi.getVerticalTextPosition(), mi.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, mi.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap, isTopLevelMenu);
        if (checkIcon != null && !isTopLevelMenu) {
            SyntheticaIcon.paintIcon(checkIcon, sc, g, SyntheticaMenuItemUI.checkIconRect.x, SyntheticaMenuItemUI.checkIconRect.y, SyntheticaMenuItemUI.checkIconRect.width, SyntheticaMenuItemUI.checkIconRect.height);
        }
        if (c instanceof JMenu && sc.getRegion() != Region.MENU) {
            sc = SyntheticaMenuItemUI.getContext(c, Region.MENU);
            style = sc.getStyle();
        }
        if (mi.getIcon() != null) {
            Icon icon = null;
            if (!model.isEnabled()) {
                icon = mi.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = mi.getPressedIcon();
            } else if (model.isRollover() && model.isSelected()) {
                icon = mi.getRolloverSelectedIcon();
            } else if (model.isRollover()) {
                icon = mi.getRolloverIcon();
            } else if (model.isSelected()) {
                icon = mi.getSelectedIcon();
            }
            if (icon == null) {
                icon = mi.getIcon();
            }
            if (icon != null) {
                SyntheticaIcon.paintIcon(icon, sc, g, SyntheticaMenuItemUI.iconRect.x, SyntheticaMenuItemUI.iconRect.y, SyntheticaMenuItemUI.iconRect.width, SyntheticaMenuItemUI.iconRect.height);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(style.getColor(sc, ColorType.TEXT_FOREGROUND));
                g.setFont(style.getFont(sc));
                style.getGraphicsUtils(sc).paintText(sc, g, text, SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.textRect.y, mi.getDisplayedMnemonicIndex());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            SynthStyle accStyle = accContext.getStyle();
            g.setColor(accStyle.getColor(accContext, ColorType.TEXT_FOREGROUND));
            g.setFont(accStyle.getFont(accContext));
            accStyle.getGraphicsUtils(accContext).paintText(accContext, g, acceleratorText, SyntheticaMenuItemUI.acceleratorRect.x - accOffset, SyntheticaMenuItemUI.acceleratorRect.y, -1);
        }
        if (arrowIcon != null && !isTopLevelMenu) {
            SyntheticaIcon.paintIcon(arrowIcon, sc, g, SyntheticaMenuItemUI.arrowIconRect.x, SyntheticaMenuItemUI.arrowIconRect.y, SyntheticaMenuItemUI.arrowIconRect.width, SyntheticaMenuItemUI.arrowIconRect.height);
        }
        if (paintDebugRects) {
            g.setColor(Color.ORANGE);
            g.drawRect(SyntheticaMenuItemUI.viewRect.x, SyntheticaMenuItemUI.viewRect.y, SyntheticaMenuItemUI.viewRect.width - 1, SyntheticaMenuItemUI.viewRect.height - 1);
            g.setColor(Color.RED);
            g.drawRect(SyntheticaMenuItemUI.checkIconRect.x, SyntheticaMenuItemUI.checkIconRect.y, SyntheticaMenuItemUI.checkIconRect.width - 1, SyntheticaMenuItemUI.checkIconRect.height - 1);
            g.setColor(Color.YELLOW);
            g.drawRect(SyntheticaMenuItemUI.iconRect.x, SyntheticaMenuItemUI.iconRect.y, SyntheticaMenuItemUI.iconRect.width - 1, SyntheticaMenuItemUI.iconRect.height - 1);
            g.setColor(Color.GREEN);
            g.drawRect(SyntheticaMenuItemUI.textRect.x, SyntheticaMenuItemUI.textRect.y, SyntheticaMenuItemUI.textRect.width - 1, SyntheticaMenuItemUI.textRect.height - 1);
            g.setColor(Color.CYAN);
            g.drawRect(SyntheticaMenuItemUI.acceleratorRect.x, SyntheticaMenuItemUI.acceleratorRect.y, SyntheticaMenuItemUI.acceleratorRect.width - 1, SyntheticaMenuItemUI.acceleratorRect.height - 1);
            g.setColor(Color.BLUE);
            g.drawRect(SyntheticaMenuItemUI.arrowIconRect.x, SyntheticaMenuItemUI.arrowIconRect.y, SyntheticaMenuItemUI.arrowIconRect.width - 1, SyntheticaMenuItemUI.arrowIconRect.height - 1);
        }
    }

    private static String modifiersAsText(int modifiers) {
        if (OS.getCurrentOS() == OS.Mac && SyntheticaLookAndFeel.getBoolean("Synthetica.menuItem.useMacAcceleratorChars", null, false)) {
            return SyntheticaMenuItemUI.getMacKeyModifiersText(modifiers);
        }
        return SyntheticaMenuItemUI.getKeyModifiersText(modifiers);
    }

    private static String getAcceleratorDelimiter() {
        String delimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        return delimiter == null ? "+" : delimiter;
    }

    private static String getKeyModifiersText(int modifiers) {
        String delimiter = SyntheticaMenuItemUI.getAcceleratorDelimiter();
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 0x100) == 256) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.meta", "Meta")) + delimiter);
        }
        if ((modifiers & 0x80) == 128) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.control", "Ctrl")) + delimiter);
        }
        if ((modifiers & 0x200) == 512) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.alt", "Alt")) + delimiter);
        }
        if ((modifiers & 0x40) == 64) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.shift", "Shift")) + delimiter);
        }
        if ((modifiers & 0x2000) == 8192) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.altGraph", "Alt Graph")) + delimiter);
        }
        if ((modifiers & 0x400) == 1024) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.button1", "Button1")) + delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    private static String getMacKeyModifiersText(int modifiers) {
        String delimiter = SyntheticaMenuItemUI.getAcceleratorDelimiter();
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 0x80) == 128) {
            sb.append("\u2303" + delimiter);
        }
        if ((modifiers & 0x40) == 64) {
            sb.append("\u21e7" + delimiter);
        }
        if ((modifiers & 0x200) == 512) {
            sb.append("\u2325" + delimiter);
        }
        if ((modifiers & 0x2000) == 8192) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.altGraph", "Alt Graph")) + delimiter);
        }
        if ((modifiers & 0x100) == 256) {
            sb.append("\u2318" + delimiter);
        }
        if ((modifiers & 0x400) == 1024) {
            sb.append(String.valueOf(Toolkit.getProperty("AWT.button1", "Button1")) + delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static void resetPopupMenu(JPopupMenu popup) {
        maxWidths.remove(popup);
    }

    static SynthContext getMenuItemContext(JComponent c) {
        boolean topLevelMenu = c instanceof JMenu && ((JMenu)c).isTopLevelMenu();
        Region region = topLevelMenu ? Region.MENU : Region.MENU_ITEM;
        return SyntheticaMenuItemUI.getContext(c, region);
    }

    static SynthStyle getStyle(JComponent c) {
        return SynthLookAndFeel.getStyle(c, SyntheticaMenuItemUI.getRegion(c));
    }

    static SynthContext getContext(JComponent c) {
        return SyntheticaMenuItemUI.getContext(c, SyntheticaMenuItemUI.getComponentState(c));
    }

    static SynthContext getContext(JComponent c, int state) {
        return SyntheticaMenuItemUI.getContext(c, SyntheticaMenuItemUI.getRegion(c), state);
    }

    static SynthContext getContext(JComponent c, Region region) {
        return SyntheticaMenuItemUI.getContext(c, region, SyntheticaMenuItemUI.getComponentState(c));
    }

    private static SynthContext getContext(JComponent c, Region region, int state) {
        SynthStyle ss = SynthLookAndFeel.getStyle(c, region);
        SynthContext sc = new SynthContext(c, region, ss, state);
        return sc;
    }

    private static Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private static int getComponentState(JComponent c) {
        int state = 0;
        state = !c.isEnabled() ? 8 : (((JMenuItem)c).isArmed() ? 2 : (c.isEnabled() ? (c.isFocusOwner() ? 257 : 1) : 8));
        if (((JMenuItem)c).isSelected()) {
            state |= 0x200;
        }
        return state;
    }

    private static JPopupMenu findPopup(Container c) {
        return (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, c);
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (SyntheticaLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JMenuItem)evt.getSource());
        } else if ("Synthetica.menuItem.arrowIcon".equals(name)) {
            this.menuItem.updateUI();
        } else if (("text".equals(name) || "icon".equals(name)) && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.dynamicItemSupport", null)) {
            SyntheticaMenuItemUI.resetPopupMenu(SyntheticaMenuItemUI.findPopup((JMenuItem)evt.getSource()));
        }
    }

    private static class MaxWidth {
        int maxTextWidth;
        int maxAcceleratorWidth;
        int maxIconWidth;
        int maxCheckIconWidth;
        int maxArrowIconWidth;

        private MaxWidth() {
        }

        public void clear() {
            this.maxTextWidth = 0;
            this.maxAcceleratorWidth = 0;
            this.maxIconWidth = 0;
            this.maxCheckIconWidth = 0;
            this.maxArrowIconWidth = 0;
        }
    }
}

