/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;

public class AnimationThreadFactory {
    public static final int DISABLED_TYPE = -1;
    public static final int DEFAULT_TYPE = 0;
    public static final int HOVER_IN_TYPE = 1;
    public static final int HOVER_OUT_TYPE = 2;
    public static final int FOCUSED_TYPE = 3;
    public static final int DISPOSABLE_TYPE = 4;
    public static final int ACTIVE_TYPE = 5;
    public static final int INACTIVE_TYPE = 6;
    private static HashMap<Integer, AnimationThread> threads = new HashMap();
    private static AnimationThreadFactory instance = new AnimationThreadFactory();

    private AnimationThreadFactory() {
    }

    public static AnimationThread createThread(int delay) {
        if (threads.containsKey(delay)) {
            return threads.get(delay);
        }
        return instance.newThread(delay);
    }

    private AnimationThread newThread(int delay) {
        AnimationThread t = new AnimationThread(delay);
        threads.put(delay, t);
        t.setDaemon(true);
        t.start();
        return t;
    }

    static class AnimationThread
    extends Thread {
        private int delay = 0;
        private HashMap<ComponentKey, ComponentAnimation> componentAnimations = new HashMap();
        private ReferenceQueue<JComponent> queue = new ReferenceQueue();

        public AnimationThread(int delay) {
            this.delay = delay;
            this.setPriority(7);
            this.setName("SyntheticaAnimation " + delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    AnimationThread.sleep(this.delay);
                    HashMap<ComponentKey, ComponentAnimation> map = null;
                    HashMap<ComponentKey, ComponentAnimation> hashMap = this.componentAnimations;
                    synchronized (hashMap) {
                        Reference<JComponent> r = this.queue.poll();
                        while (r != null) {
                            this.componentAnimations.remove(((WeakComponent)r).key);
                            r = this.queue.poll();
                        }
                        map = new HashMap<ComponentKey, ComponentAnimation>(this.componentAnimations);
                    }
                    for (Map.Entry<ComponentKey, ComponentAnimation> entry : map.entrySet()) {
                        JComponent c = (JComponent)entry.getKey().wc.get();
                        if (c == null) continue;
                        ComponentAnimation ca = entry.getValue();
                        if (c == null || ca == null) continue;
                        Component view = null;
                        if (c instanceof JScrollPane) {
                            view = ((JScrollPane)c).getViewport().getView();
                        }
                        boolean repaint = false;
                        Rectangle repaintRect = null;
                        ComponentAnimation componentAnimation = ca;
                        synchronized (componentAnimation) {
                            boolean hover = (ca.state & 2) > 0;
                            boolean focused = c.hasFocus();
                            repaintRect = ca.repaintRect;
                            switch (ca.type) {
                                case 4: 
                                case 5: 
                                case 6: {
                                    if (!ca.next()) break;
                                    repaint = true;
                                    break;
                                }
                                case 1: {
                                    if (ca.state != -1 && hover && ca.next()) {
                                        repaint = true;
                                        break;
                                    }
                                    if (ca.state == -1 || hover) break;
                                    ca.reset();
                                    break;
                                }
                                case 2: {
                                    if (ca.state != -1 && !hover && ca.next()) {
                                        repaint = true;
                                        break;
                                    }
                                    if (ca.state == -1 || !hover) break;
                                    ca.reset();
                                    break;
                                }
                                case 3: {
                                    Component cc;
                                    if (c instanceof JComboBox && ((JComboBox)c).isEditable() && ((JComboBox)c).getEditor() != null) {
                                        cc = ((JComboBox)c).getEditor().getEditorComponent();
                                        if (cc != null) {
                                            focused = cc.hasFocus();
                                        }
                                    } else if (c instanceof JSpinner) {
                                        cc = SyntheticaLookAndFeel.findComponent("Spinner.formattedTextField", (Container)c);
                                        if (cc != null) {
                                            focused = cc.hasFocus();
                                        }
                                    } else if (c instanceof JScrollPane) {
                                        JScrollPane sp = (JScrollPane)c;
                                        if (view != null) {
                                            focused = view.hasFocus();
                                        }
                                        int maxAnimationWidth = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxWidth", (Component)sp, 400);
                                        int maxAnimationHeight = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxHeight", (Component)sp, 200);
                                        if (sp.getWidth() > maxAnimationWidth || sp.getHeight() > maxAnimationHeight) break;
                                    }
                                    if (ca.next() && focused && this.isActive(c)) {
                                        repaint = true;
                                        break;
                                    }
                                    if (focused) break;
                                    ca.reset();
                                    break;
                                }
                                default: {
                                    if (!ca.next() || !this.isActive(c)) break;
                                    repaint = true;
                                }
                            }
                        }
                        if (!repaint) continue;
                        this.repaint(c, repaintRect);
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private void repaint(JComponent c, Rectangle rect) {
            if (rect == null) {
                c.repaint();
            } else {
                c.repaint(0L, rect.x, rect.y, rect.width, rect.height);
            }
        }

        private boolean isActive(JComponent c) {
            Container con = c.getTopLevelAncestor();
            if (con instanceof Window && !"###focusableSwingPopup###".equals(con.getName())) {
                return ((Window)con).isActive();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JComponent c, String id, int state, int type, String[] imagePaths, int cycles, Rectangle repaintRect) {
            boolean hover = (state & 2) > 0;
            ComponentKey ck = new ComponentKey(c, id);
            if (this.componentAnimations.containsKey(ck)) {
                ComponentAnimation ca;
                ComponentAnimation componentAnimation = ca = this.componentAnimations.get(ck);
                synchronized (componentAnimation) {
                    ca.repaintRect = repaintRect;
                    if (ca.type != type || !Arrays.toString(imagePaths).equals(Arrays.toString(ca.imagePaths))) {
                        ca.reset();
                        ca.type = type;
                        ca.imagePaths = imagePaths;
                        ca.cyles = cycles;
                    }
                    if (ca.state != -1 || hover) {
                        ca.state = state;
                    }
                }
                return;
            }
            ck.setComponent(c);
            ComponentAnimation ca = new ComponentAnimation();
            ca.imagePaths = imagePaths;
            ca.cyles = cycles;
            ca.repaintRect = repaintRect;
            ca.type = type;
            if (hover) {
                ca.state = state;
            } else if (type == 6) {
                ca.cylesDone = cycles;
            }
            HashMap<ComponentKey, ComponentAnimation> hashMap = this.componentAnimations;
            synchronized (hashMap) {
                this.componentAnimations.put(ck, ca);
            }
        }

        void rotateRepaintRect(JComponent c, String id) {
            ComponentKey ck = new ComponentKey(c, id);
            ComponentAnimation ca = this.componentAnimations.get(ck);
            if (ca != null) {
                int val = ((ComponentAnimation)ca).repaintRect.height;
                ((ComponentAnimation)ca).repaintRect.height = ((ComponentAnimation)ca).repaintRect.width;
                ((ComponentAnimation)ca).repaintRect.width = val;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getImagePath(JComponent c, String id) {
            ComponentAnimation ca = this.componentAnimations.get(new ComponentKey(c, id));
            String path = null;
            ComponentAnimation componentAnimation = ca;
            synchronized (componentAnimation) {
                path = ca.type == 2 && (ca.state == -1 || ca.isComplete()) ? ca.imagePaths[ca.imagePaths.length - 1] : (ca.type == 6 && ca.isComplete() ? ca.imagePaths[ca.imagePaths.length - 1] : ca.imagePaths[ca.index]);
            }
            return path;
        }

        private static class ComponentAnimation {
            private int state = -1;
            private int type = 0;
            private int index = 0;
            private String[] imagePaths;
            private Rectangle repaintRect;
            private long cyles = 0L;
            private long cylesDone = 0L;

            private ComponentAnimation() {
            }

            boolean next() {
                if (this.cyles == 0L || this.cylesDone == this.cyles || this.imagePaths.length == 1) {
                    return false;
                }
                ++this.index;
                if (this.index == this.imagePaths.length - 1) {
                    ++this.cylesDone;
                } else if (this.index == this.imagePaths.length) {
                    this.index = 0;
                }
                return true;
            }

            void reset() {
                this.index = 0;
                this.cylesDone = 0L;
            }

            boolean isComplete() {
                return this.cyles == this.cylesDone;
            }
        }

        private class ComponentKey {
            private int hashCode;
            private WeakComponent wc;

            ComponentKey(JComponent c, String id) {
                this.hashCode = c.hashCode() * 31 + id.hashCode();
            }

            void setComponent(JComponent c) {
                this.wc = new WeakComponent(c, this);
            }

            public boolean equals(Object obj) {
                ComponentKey ck = (ComponentKey)obj;
                return ck.hashCode == this.hashCode;
            }

            public int hashCode() {
                return this.hashCode;
            }
        }

        private class WeakComponent
        extends WeakReference<JComponent> {
            private ComponentKey key;

            public WeakComponent(JComponent c, ComponentKey key) {
                super(c, AnimationThread.this.queue);
                this.key = key;
            }
        }
    }
}

