/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class OptionPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.OptionPanePainter";

    protected OptionPanePainter() {
    }

    public static OptionPanePainter getInstance() {
        return OptionPanePainter.getInstance(null);
    }

    public static OptionPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(OptionPanePainter.getPainterClassName(sc, OptionPanePainter.class, UI_KEY));
        if (instance == null) {
            instance = OptionPanePainter.getInstance(sc, OptionPanePainter.class, UI_KEY);
        }
        return (OptionPanePainter)instance;
    }

    public void paintOptionPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintOptionPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintPanelBackground(sc.getComponent(), new SyntheticaState(), g, x, y, w, h);
    }

    public void paintPanelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Color background = c.getBackground();
        if (c.isOpaque() || SyntheticaLookAndFeel.getBoolean("Synthetica.optionPane.background.opaque", c, false)) {
            boolean backgroundImageEnabled;
            String inactiveImagePath = this.resolveImagePath("Synthetica.optionPane.inactive.background.image", c);
            boolean inactive = false;
            if (inactiveImagePath != null) {
                Window win = SwingUtilities.getWindowAncestor(c);
                inactive = win != null && !win.isActive();
            }
            String imagePath = inactive ? inactiveImagePath : this.resolveImagePath("Synthetica.optionPane.background.image", c);
            boolean bl = backgroundImageEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.optionPane.background.image.enabled", c, true) && !(c.getParent() instanceof CellRendererPane);
            if (!(backgroundImageEnabled && imagePath != null || background == null || background instanceof ColorUIResource)) {
                g.setColor(background);
                g.fillRect(x, y, w, h);
            } else if (backgroundImageEnabled && imagePath != null && (background == null || background != null && background instanceof ColorUIResource)) {
                Insets sInsets;
                int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.optionPane.background.horizontalTiled", c, false) ? 1 : 0;
                int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.optionPane.background.verticalTiled", c, false) ? 1 : 0;
                Insets dInsets = sInsets = this.getImageInsets("Synthetica.optionPane.background.image.insets", c);
                String origin = SyntheticaLookAndFeel.getString("Synthetica.optionPane.background.image.origin", c);
                if (origin != null && origin.equals("PANEL")) {
                    ImagePainter painter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
                    painter.draw();
                } else {
                    JRootPane container;
                    Container container2 = container = origin != null && origin.equals("CONTENT_PANE") ? c.getRootPane().getContentPane() : c.getRootPane();
                    if (container == null) {
                        return;
                    }
                    Rectangle bounds = container.getBounds();
                    bounds.width = Math.max(bounds.width, SyntheticaLookAndFeel.getInt("Synthetica.optionPane.minimumBackgroundWidth", c, bounds.width, true, false));
                    bounds.height = Math.max(bounds.height, SyntheticaLookAndFeel.getInt("Synthetica.optionPane.minimumBackgroundHeight", c, bounds.height, true, false));
                    Rectangle r = SwingUtilities.convertRectangle(c, new Rectangle(x, y, w, h), container);
                    ImagePainter painter = new ImagePainter(g, x - r.x, y - r.y, bounds.width, bounds.height, imagePath, sInsets, dInsets, xPolicy, yPolicy);
                    painter.draw();
                }
            }
        }
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        return -1;
    }
}

