/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class ScrollPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ScrollPanePainter";

    protected ScrollPanePainter() {
    }

    public static ScrollPanePainter getInstance() {
        return ScrollPanePainter.getInstance(null);
    }

    public static ScrollPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ScrollPanePainter.getPainterClassName(sc, ScrollPanePainter.class, UI_KEY));
        if (instance == null) {
            instance = ScrollPanePainter.getInstance(sc, ScrollPanePainter.class, UI_KEY);
        }
        return (ScrollPanePainter)instance;
    }

    public void paintScrollPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        boolean keyExists;
        UIKey key;
        Boolean fillBackground;
        boolean innerBorderIsDefault;
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        if (scrollPane.getViewport() == null || scrollPane.getViewport().getView() == null || !SyntheticaLookAndFeel.isOpaque(scrollPane)) {
            return;
        }
        Component view = scrollPane.getViewport().getView();
        Border border = scrollPane.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder(border);
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean isTextComponent = view instanceof JTextComponent;
        if (isTextComponent && !SyntheticaLookAndFeel.isOpaque((JTextComponent)view)) {
            return;
        }
        if (!isTextComponent && !defaultBorderIsSynth) {
            if (view.isOpaque()) {
                this.fillBackground(scrollPane, border, defaultBorder, defaultBorderIsSynth, view, g, view.getBackground(), x, y, w, h);
            }
            return;
        }
        boolean bl = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins = border.getBorderInsets(scrollPane);
            Insets ins_ = defaultBorder.getBorderInsets(scrollPane);
            x += ins.left - ins_.left;
            y += ins.top - ins_.top;
            w -= ins.left - ins_.left + ins.right - ins_.right;
            h -= ins.top - ins_.top + ins.bottom - ins_.bottom;
        }
        if (!isTextComponent) {
            Insets sInsets2;
            Color color;
            Color background = scrollPane.getBackground();
            if (background instanceof UIResource) {
                background = view.getBackground();
            }
            if ((color = g.getColor()) == null || color != null && !color.equals(background)) {
                boolean fill;
                boolean bl2 = fill = !(view instanceof JTable && !SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.table.fillBackground", view, true) || view instanceof JList && !SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.list.fillBackground", view, true) || view instanceof JTree && !SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.tree.fillBackground", view, true) || view instanceof JPanel && !SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.panel.fillBackground", view, true));
                if (defaultBorderIsSynth) {
                    if (fill) {
                        this.fillBackground(scrollPane, border, defaultBorder, defaultBorderIsSynth, view, g, background, x, y, w, h);
                    }
                } else {
                    if (fill) {
                        this.fillBackground(scrollPane, null, defaultBorder, defaultBorderIsSynth, view, g, background, x, y, w, h);
                    }
                    return;
                }
            }
            String imagePath = null;
            imagePath = view.isEnabled() ? this.resolveImagePath("Synthetica.scrollPane.border", scrollPane) : this.resolveImagePath("Synthetica.scrollPane.border.disabled", scrollPane);
            Insets dInsets = sInsets2 = this.getImageInsets("Synthetica.scrollPane.border.insets", scrollPane);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets2, dInsets, 0, 0);
            imagePainter.drawBorder();
            return;
        }
        JTextComponent tc = (JTextComponent)view;
        Color background = tc.getBackground();
        boolean defaultBackground = background == null || background instanceof ColorUIResource;
        boolean keepLockedBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.keepLockedBorderIfColored", tc);
        boolean enabled = tc.isEnabled();
        boolean locked = !tc.isEditable();
        String name = "textField";
        if (tc instanceof JTextArea) {
            name = "textArea";
        } else if (tc instanceof JEditorPane) {
            name = "editorPane";
        } else if (tc instanceof JTextPane) {
            name = "textPane";
        }
        int state_ = locked ? SyntheticaState.State.LOCKED.toInt() : 0;
        SyntheticaPainterState state = new SyntheticaPainterState(sc, state_ |= !enabled ? SyntheticaState.State.DISABLED.toInt() : 0, false);
        if (!defaultBackground && !keepLockedBorderIfColored) {
            state.resetState(SyntheticaState.State.LOCKED);
        }
        if ((fillBackground = (Boolean)SyntheticaLookAndFeel.get((key = new UIKey(String.valueOf(name) + ".border", state)).get("fillBackground"), tc)) == null || fillBackground.booleanValue()) {
            this.fillBackground(scrollPane, border, defaultBorder, defaultBorderIsSynth, tc, g, background, x, y, w, h);
        }
        boolean bl3 = keyExists = SyntheticaLookAndFeel.get(key.get(), tc) != null;
        if (locked && !keyExists) {
            state.resetState(SyntheticaState.State.LOCKED);
            key = new UIKey(String.valueOf(name) + ".border", state);
        }
        boolean bl4 = keyExists = SyntheticaLookAndFeel.get(key.get(), tc) != null;
        if (!keyExists) {
            key = new UIKey("scrollPane.border", state);
        }
        boolean opaqueBackground = SyntheticaLookAndFeel.getBoolean(key.get("solid"), tc);
        String imagePath = this.resolveImagePath(key.get(), tc);
        Insets sInsets_ = SyntheticaLookAndFeel.getInsets(key.get("insets"), (Component)tc, true, false);
        Insets dInsets = sInsets = sInsets_ == null ? this.getImageInsets("Synthetica.scrollPane.border.insets", tc) : sInsets_;
        if (!defaultBorderIsSynth) {
            Insets insets = scrollPane.getInsets();
            x += insets.left;
            y += insets.top;
            w += -insets.left - insets.right;
            h += -insets.top - insets.bottom;
            dInsets = new Insets(0, 0, 0, 0);
        }
        ImagePainter imagePainter = new ImagePainter(tc, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (opaqueBackground) {
            imagePainter.draw();
        } else {
            imagePainter.drawBorder();
        }
    }

    public void paintScrollPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        if (scrollPane.getViewport() == null || scrollPane.getViewport().getView() == null) {
            return;
        }
        Component view = scrollPane.getViewport().getView();
        boolean textComponentsFocusEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.textComponents.enabled", view, true);
        boolean scrollPaneFocusEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.scrollPane.enabled", view, true);
        if (view.hasFocus() && (!(view instanceof JTextComponent) && scrollPaneFocusEnabled || view instanceof JTextComponent && textComponentsFocusEnabled)) {
            FocusPainter.paintFocus("focus.scrollPane", sc, g, x, y, w, h);
        }
    }

    private void fillBackground(JScrollPane scrollPane, Border border, Border defaultBorder, boolean defaultBorderIsSynth, Component view, Graphics g, Color background, int x, int y, int w, int h) {
        if (background instanceof ColorUIResource && view instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)view;
            if (tc.isEnabled() && SyntheticaLookAndFeel.getClientProperty("Synthetica.MOUSE_OVER", tc, false).booleanValue()) {
                Region region = tc instanceof JTextArea ? Region.TEXT_AREA : (tc instanceof JTextPane ? Region.TEXT_PANE : Region.EDITOR_PANE);
                SynthStyle ss = SynthLookAndFeel.getStyle(tc, region);
                SynthContext sc = new SynthContext(tc, region, ss, 2);
                background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
            } else if (!tc.isEditable() || !tc.isEnabled()) {
                if (!tc.isEditable()) {
                    Color bg = null;
                    if (tc instanceof JTextArea) {
                        bg = SyntheticaLookAndFeel.getColor("Synthetica.textArea.lockedColor", tc);
                    } else if (tc instanceof JTextPane) {
                        bg = SyntheticaLookAndFeel.getColor("Synthetica.textPane.lockedColor", tc);
                    } else if (tc instanceof JEditorPane) {
                        bg = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.lockedColor", tc);
                    }
                    if (bg == null && !tc.isEnabled()) {
                        bg = this.getDisabledBackgroundColor(tc);
                    }
                    if (bg != null) {
                        background = bg;
                    }
                } else if (!tc.isEnabled()) {
                    background = this.getDisabledBackgroundColor(tc);
                }
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Color color = g2.getColor();
        g2.setColor(background);
        Insets insets = scrollPane.getInsets();
        if (border == null || insets.equals(new Insets(0, 0, 0, 0))) {
            g2.fillRect(x, y, w, h);
        } else if (!defaultBorderIsSynth) {
            g.fillRect(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        } else {
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets fillInsets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.fillInsets", (Component)scrollPane, false, true);
            int arcWidth = SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcWidth", scrollPane, 8, true);
            int arcHeight = SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcHeight", scrollPane, 8, true);
            g2.fillRoundRect(x + fillInsets.left, y + fillInsets.top, w - fillInsets.left - fillInsets.right, h - fillInsets.top - fillInsets.bottom, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
        }
        g2.setColor(color);
    }

    private Color getDisabledBackgroundColor(JTextComponent tc) {
        Color background = null;
        if (tc instanceof JTextArea) {
            background = SyntheticaLookAndFeel.getColor("Synthetica.textArea.disabledColor", tc);
        } else if (tc instanceof JTextPane) {
            background = SyntheticaLookAndFeel.getColor("Synthetica.textPane.disabledColor", tc);
        } else if (tc instanceof JEditorPane) {
            background = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.disabledColor", tc);
        }
        return background;
    }

    public void paintScrollPaneCorner(JScrollPane scrollPane, Graphics g, int x, int y, int w, int h, String cornerID) {
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        if (view != null) {
            boolean enabled = view.isEnabled();
            boolean focused = view.hasFocus();
            boolean locked = view instanceof JTextComponent ? !((JTextComponent)view).isEditable() : false;
            Color background = view.getBackground();
            Boolean viewOpaque = (Boolean)view.getClientProperty("Synthetica.opaque");
            hash = 31 * hash + view.getClass().hashCode();
            int n = hash = background == null ? hash : 31 * hash + background.getRGB();
            hash = viewOpaque == null ? hash : 31 * hash + (viewOpaque != false ? 0 : 1);
            hash = 31 * hash + (enabled ? 0 : 1);
            hash = 31 * hash + (focused ? 0 : 1);
            hash = 31 * hash + (locked ? 0 : 1);
        }
        return hash;
    }

    @Override
    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        Insets insets;
        if (id.equals("paintScrollPaneBorder") && (insets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", (Component)sc.getComponent(), true, true)) != null) {
            return insets;
        }
        return super.getCacheScaleInsets(sc, id);
    }
}

